/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.service.imq.websocket.stomp;

import com.sun.messaging.bridge.api.StompConnection;
import com.sun.messaging.bridge.api.StompFrameMessage;
import com.sun.messaging.bridge.api.StompNotConnectedException;
import com.sun.messaging.bridge.api.StompOutputHandler;
import com.sun.messaging.bridge.api.StompProtocolException;
import com.sun.messaging.bridge.api.StompProtocolHandler;
import com.sun.messaging.bridge.api.StompSession;
import com.sun.messaging.bridge.api.StompSubscriber;
import com.sun.messaging.jmq.io.Packet;
import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.resources.BrokerResources;
import com.sun.messaging.jmq.jmsserver.service.Connection;
import com.sun.messaging.jmq.jmsserver.service.ConnectionClosedListener;
import com.sun.messaging.jmq.jmsserver.service.ConnectionUID;
import com.sun.messaging.jmq.jmsserver.service.imq.websocket.stomp.StompProtocolHandlerImpl;
import com.sun.messaging.jmq.jmsserver.service.imq.websocket.stomp.StompSenderSession;
import com.sun.messaging.jmq.jmsserver.service.imq.websocket.stomp.StompSubscriberSession;
import com.sun.messaging.jmq.jmsserver.service.imq.websocket.stomp.StompTransactedSession;
import com.sun.messaging.jmq.jmsservice.JMSService;
import com.sun.messaging.jmq.jmsservice.JMSServiceReply;
import com.sun.messaging.jmq.util.log.Logger;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.jms.IllegalStateException;

public class StompConnectionImpl
implements StompConnection,
ConnectionClosedListener {
    private static final Logger logger = Globals.getLogger();
    private static final BrokerResources br = Globals.getBrokerResources();
    private StompProtocolHandlerImpl sph = null;
    private JMSService jmsservice = null;
    private String clientID = null;
    private Long connectionID = null;
    private StompSenderSession pubSession = null;
    private StompTransactedSession txSession = null;
    private Map<String, StompSubscriberSession> subSessions = Collections.synchronizedMap(new HashMap());
    private int nextTempDestIndex = 0;
    private Object closeLock = new Object();
    private boolean closing = false;
    private boolean closed = true;

    public StompConnectionImpl(StompProtocolHandlerImpl h) {
        this.sph = h;
        this.jmsservice = this.sph.getJMSService();
    }

    protected boolean getDEBUG() {
        return this.sph.getDEBUG();
    }

    protected StompProtocolHandler getProtocolHandler() {
        return this.sph;
    }

    protected JMSService getJMSService() {
        return this.jmsservice;
    }

    protected synchronized String getIdForTemporaryDestination() throws Exception {
        this.checkConnection();
        return this.sph.getRemoteAddress().getHostAddress() + (this.clientID == null ? "" : "/" + this.clientID) + "/" + this.connectionID + "/" + this.nextTempDestIndex++;
    }

    protected synchronized void fillRemoteIPAndPort(Packet pkt) throws Exception {
        this.checkConnection();
        pkt.setIP(this.sph.getRemoteAddress().getAddress());
        pkt.setPort(this.sph.getRemotePort());
    }

    @Override
    public synchronized String connect(String login, String passcode, String clientid) throws Exception {
        this.clientID = clientid;
        if (this.connectionID != null) {
            throw new IllegalStateException("Unexpected " + (Object)((Object)StompFrameMessage.Command.CONNECT) + ", already connected");
        }
        JMSServiceReply reply = this.jmsservice.createConnection(login, passcode, null);
        long connid = reply.getJMQConnectionID();
        this.connectionID = connid;
        this.closed = false;
        Connection conn = Globals.getConnectionManager().getConnection(new ConnectionUID(connid));
        if (conn == null) {
            throw new StompProtocolException("No connection");
        }
        conn.addConnectionClosedListener(this);
        this.jmsservice.setClientId(connid, clientid, false, null);
        this.jmsservice.startConnection(connid);
        return this.connectionID.toString();
    }

    @Override
    public void connectionClosed(Connection conn) {
        if (!conn.getConnectionUID().equals((Object)new ConnectionUID(this.connectionID))) {
            return;
        }
        if (!this.isClosed()) {
            String emsg = br.getKString("B1509", String.valueOf(this.connectionID));
            logger.log(16, emsg);
            this.sph.close(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void disconnect(boolean closeCheck) throws Exception {
        Map<String, StompSubscriberSession> map = this.closeLock;
        synchronized (map) {
            block33: {
                block35: {
                    block34: {
                        if (closeCheck) {
                            this.checkConnection();
                        }
                        if (!this.closed && !this.closing) break block33;
                        if (logger.isFineLoggable()) break block34;
                        if (!this.getProtocolHandler().getDEBUG()) break block35;
                    }
                    logger.log(8, br.getKString("B1511", String.valueOf(this.connectionID)));
                }
                return;
            }
            this.closing = true;
        }
        try {
            if (this.pubSession != null) {
                this.pubSession.close();
            }
            if (this.txSession != null) {
                this.txSession.close();
            }
            map = this.subSessions;
            synchronized (map) {
                for (String subid : this.subSessions.keySet()) {
                    StompSubscriberSession ss = this.subSessions.get(subid);
                    ss.close();
                }
                this.subSessions.clear();
            }
        }
        catch (Exception e) {
            if (this.getDEBUG()) {
                logger.logStack(16, e.getMessage(), (Throwable)e);
            }
        }
        finally {
            try {
                this.jmsservice.destroyConnection(this.connectionID);
            }
            catch (Exception e) {
                if (this.getDEBUG()) {
                    logger.logStack(16, e.getMessage(), (Throwable)e);
                }
                logger.log(16, e.getMessage());
            }
            Object object = this.closeLock;
            synchronized (object) {
                this.closed = true;
            }
        }
        logger.log(8, br.getKString("B1512", String.valueOf(this.connectionID)));
    }

    private StompSenderSession getSenderSession() throws Exception {
        this.checkConnection();
        if (this.pubSession == null) {
            this.pubSession = new StompSenderSession(this);
        }
        return this.pubSession;
    }

    @Override
    public void sendMessage(StompFrameMessage message, String tid) throws Exception {
        StompSenderSession ss = null;
        if (tid != null) {
            ss = (StompSenderSession)this.getTransactedSession(tid);
            if (logger.isFineLoggable()) {
                logger.logFine("Sending message on transacted session: " + ss + " for transaction " + tid, null);
            }
        } else {
            ss = this.getSenderSession();
        }
        ss.sendStompMessage(message);
    }

    private StompSession getTransactedSession(String tid) throws Exception {
        this.checkConnection();
        if (tid == null) {
            throw new IllegalArgumentException("Unexpected call: null transaction id");
        }
        if (this.txSession == null) {
            throw new StompProtocolException(br.getKString("B4476", tid));
        }
        String currtid = this.txSession.getStompTransactionId();
        if (currtid == null || !currtid.equals(tid)) {
            throw new StompProtocolException(br.getKString("B4474", tid + "[" + (currtid == null ? "" : "current:" + currtid) + "]"));
        }
        return this.txSession;
    }

    public StompSession getTransactedSession() throws Exception {
        this.checkConnection();
        if (this.txSession == null) {
            return null;
        }
        if (this.txSession.getStompTransactionId() == null) {
            return null;
        }
        return this.txSession;
    }

    private StompSubscriberSession createSubscriberSession(String subid, StompProtocolHandler.StompAckMode ackMode) throws Exception {
        this.checkConnection();
        if (subid == null) {
            throw new IllegalArgumentException("No subscription id");
        }
        StompSubscriberSession ss = this.subSessions.get(subid);
        if (ss != null) {
            throw new StompProtocolException(br.getKString("B4470", subid));
        }
        ss = new StompSubscriberSession(subid, ackMode, this);
        this.subSessions.put(subid, ss);
        return ss;
    }

    @Override
    public StompSubscriber createSubscriber(String subid, String stompdest, StompProtocolHandler.StompAckMode ackMode, String selector, String duraname, boolean nolocal, String tid, StompOutputHandler aout) throws Exception {
        StompSubscriber sub = null;
        if (tid == null) {
            StompSubscriberSession ss = this.createSubscriberSession(subid, ackMode);
            sub = ss.createSubscriber(this.sph.toStompDestination(stompdest, ss, true), selector, duraname, nolocal, aout);
        } else {
            StompTransactedSession ts = (StompTransactedSession)this.getTransactedSession(tid);
            sub = ts.createSubscriber(subid, this.sph.toStompDestination(stompdest, ts, true), selector, duraname, nolocal, aout);
        }
        return sub;
    }

    private StompSubscriberSession getSubscriberSession(String subid) throws Exception {
        this.checkConnection();
        if (subid == null) {
            throw new IllegalArgumentException("No subscription id");
        }
        StompSubscriberSession ss = this.subSessions.get(subid);
        return ss;
    }

    @Override
    public void ack10(String subidPrefix, String msgid, String tid) throws Exception {
        throw new StompProtocolException("STOMP 1.0 no subscription id ACK is not supported");
    }

    @Override
    public void ack(String id, String tid, String subid, String msgid, boolean nack) throws Exception {
        if (id == null && subid == null) {
            throw new IllegalArgumentException("ack(): null subid");
        }
        if (tid != null) {
            StompTransactedSession ts = (StompTransactedSession)this.getTransactedSession(tid);
            ts.ack(subid, msgid, nack);
        } else {
            StompSubscriberSession ss = this.getSubscriberSession(subid);
            if (ss != null) {
                ss.ack(msgid, nack);
            } else {
                StompTransactedSession ts = (StompTransactedSession)this.getTransactedSession();
                if (ts == null) {
                    throw new StompProtocolException(br.getKString("B4478", subid, msgid));
                }
                ts.ack(subid, msgid, nack);
            }
        }
    }

    @Override
    public String closeSubscriber(String subid, String duraname) throws Exception {
        this.checkConnection();
        StompSubscriberSession ss = null;
        if (duraname == null) {
            ss = this.subSessions.get(subid);
            if (ss != null) {
                ss.close();
                this.subSessions.remove(subid);
                return null;
            }
        } else {
            if (this.getClientID() == null) {
                throw new StompProtocolException(br.getKString("B4453", duraname));
            }
            String dn = null;
            for (String sid : this.subSessions.keySet()) {
                ss = this.subSessions.get(sid);
                dn = ss.getDurableName();
                if (dn == null || !dn.equals(duraname)) continue;
                ss.closeSubscribers();
                ss.unsubscribeDurable(duraname);
                ss.close();
                this.subSessions.remove(sid);
                return sid;
            }
        }
        if (this.txSession != null) {
            String sid = this.txSession.closeSubscriber(subid, duraname);
            if (duraname != null) {
                return sid;
            }
            if (sid != null) {
                return sid;
            }
        } else if (duraname != null) {
            this.getSenderSession().unsubscribeDurable(duraname);
        }
        throw new StompProtocolException(br.getKString("B4472", subid));
    }

    @Override
    public void beginTransactedSession(String tid) throws Exception {
        String currtid;
        this.checkConnection();
        if (tid == null) {
            throw new IllegalArgumentException("Unexpected call: null transaction id");
        }
        if (this.txSession == null) {
            this.txSession = new StompTransactedSession(this);
        }
        if ((currtid = this.txSession.getStompTransactionId()) != null) {
            throw new StompProtocolException(br.getKString("B4477", tid, currtid));
        }
        this.txSession.begin(tid);
    }

    @Override
    public void commitTransactedSession(String tid) throws Exception {
        this.checkConnection();
        if (tid == null) {
            throw new IllegalArgumentException("Unexpected call: null transaction id");
        }
        if (this.txSession == null) {
            throw new StompProtocolException(br.getKString("B4476", tid));
        }
        String currtid = this.txSession.getStompTransactionId();
        if (currtid == null || !currtid.equals(tid)) {
            throw new StompProtocolException(br.getKString("B4474", tid + "[" + (currtid == null ? "" : "current:" + currtid) + "]"));
        }
        this.txSession.commit();
    }

    @Override
    public void abortTransactedSession(String tid) throws Exception {
        this.checkConnection();
        if (tid == null) {
            throw new IllegalArgumentException("Unexpected call: null transaction id");
        }
        if (this.txSession == null) {
            throw new StompProtocolException(br.getKString("B4476", tid));
        }
        String currtid = this.txSession.getStompTransactionId();
        String lastrb = this.txSession.getLastRolledbackStompTransactionId();
        if (currtid == null && lastrb != null && lastrb.equals(tid)) {
            logger.log(8, br.getKString("B4475", tid));
            return;
        }
        if (currtid == null || !currtid.equals(tid)) {
            throw new StompProtocolException(br.getKString("B4474", tid + "[" + (currtid == null ? "" : "current:" + currtid) + "]"));
        }
        this.txSession.rollback();
    }

    protected Long getConnectionID() throws Exception {
        this.checkConnection();
        return this.connectionID;
    }

    protected synchronized String getClientID() throws Exception {
        this.checkConnection();
        return this.clientID;
    }

    public String toString() {
        Long id = this.connectionID;
        return "[" + (id == null ? "" : id.toString()) + "]";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkConnection() throws Exception {
        Object object = this.closeLock;
        synchronized (object) {
            if (this.closing || this.closed) {
                throw new StompNotConnectedException(br.getKString("B1511", String.valueOf(this.connectionID)));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean isClosed() {
        Object object = this.closeLock;
        synchronized (object) {
            return this.closing || this.closed;
        }
    }
}

