/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.multibroker.raptor;

import com.sun.messaging.jmq.io.GPacket;
import com.sun.messaging.jmq.jmsserver.core.BrokerAddress;
import com.sun.messaging.jmq.jmsserver.multibroker.raptor.ReplyStatus;
import com.sun.messaging.jmq.jmsserver.multibroker.raptor.ReplyWaiter;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import com.sun.messaging.jmq.util.UID;
import com.sun.messaging.jmq.util.UniqueID;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;

class ReplyTracker {
    private Map waiters = Collections.synchronizedMap(new LinkedHashMap());

    public Long addWaiter(ReplyWaiter waiter) {
        Long xid = UniqueID.generateID((short)UID.getPrefix());
        this.waiters.put(xid, waiter);
        return xid;
    }

    public void addWaiter(Long xid, ReplyWaiter waiter) {
        this.waiters.put(xid, waiter);
    }

    protected ReplyWaiter getWaiter(Long xid) {
        return (ReplyWaiter)this.waiters.get(xid);
    }

    public void removeWaiter(Long xid) {
        this.waiters.remove(xid);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ReplyStatus waitForReply(Long xid, int timeout) throws BrokerException {
        ReplyWaiter waiter = (ReplyWaiter)this.waiters.get(xid);
        assert (waiter != null);
        try {
            ReplyStatus replyStatus = waiter.waitForReply(timeout);
            return replyStatus;
        }
        finally {
            this.waiters.remove(xid);
        }
    }

    public boolean notifyReply(Long xid, BrokerAddress from, GPacket reply) {
        ReplyWaiter waiter = (ReplyWaiter)this.waiters.get(xid);
        if (waiter == null) {
            return false;
        }
        waiter.notifyReply(from, reply);
        return true;
    }

    public void abortWaiter(Long xid) {
        ReplyWaiter waiter = (ReplyWaiter)this.waiters.get(xid);
        if (waiter == null) {
            return;
        }
        waiter.abort();
    }

    public void addBroker(BrokerAddress remote) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeBroker(BrokerAddress remote, boolean goodbyed, boolean shutdown) {
        Long xid2 = null;
        ReplyWaiter waiter = null;
        Set s = this.waiters.keySet();
        Map map = this.waiters;
        synchronized (map) {
            for (Long xid2 : s) {
                waiter = (ReplyWaiter)this.waiters.get(xid2);
                waiter.removeParticipant(remote, goodbyed, shutdown);
            }
        }
    }
}

