/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.multibroker;

import com.sun.messaging.jmq.io.GPacket;
import com.sun.messaging.jmq.jmsserver.core.BrokerAddress;
import com.sun.messaging.jmq.jmsserver.core.Subscription;
import com.sun.messaging.jmq.jmsserver.multibroker.ChangeRecord;
import com.sun.messaging.jmq.jmsserver.multibroker.raptor.ClusterSubscriptionInfo;
import com.sun.messaging.jmq.jmsserver.persist.api.ChangeRecordInfo;

public class InterestUpdateChangeRecord
extends ChangeRecord {
    private String dname;
    private String cid;
    private Boolean shared = null;
    private Boolean jmsshared = null;
    private BrokerAddress broker = null;

    public InterestUpdateChangeRecord(GPacket gp) {
        this.operation = gp.getType();
        ClusterSubscriptionInfo csi = ClusterSubscriptionInfo.newInstance(gp);
        this.dname = csi.getDurableName();
        this.cid = csi.getClientID();
        this.shared = csi.getShared();
        this.jmsshared = csi.getJMSShared();
    }

    public String getSubscriptionKey() {
        return Subscription.getDSubKey(this.cid, this.dname);
    }

    @Override
    public String getUniqueKey() {
        return "dur:" + Subscription.getDSubKey(this.cid, this.dname);
    }

    public Boolean getShared() {
        return this.shared;
    }

    public Boolean getJMSShared() {
        return this.jmsshared;
    }

    @Override
    public boolean isAddOp() {
        return this.operation == 5;
    }

    @Override
    public void transferFlag(ChangeRecordInfo cri) {
        if (this.shared != null && this.shared.booleanValue()) {
            cri.setFlagBit(1);
        }
        if (this.jmsshared != null && this.jmsshared.booleanValue()) {
            cri.setFlagBit(2);
        }
    }

    public String getFlagString() {
        ChangeRecordInfo cri = new ChangeRecordInfo();
        this.transferFlag(cri);
        return ChangeRecordInfo.getFlagString(cri.getFlag());
    }

    public void setBroker(BrokerAddress b) {
        this.broker = b;
    }

    public BrokerAddress getBroker() {
        return this.broker;
    }
}

