/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.data.handlers.admin;

import com.sun.messaging.jmq.io.Packet;
import com.sun.messaging.jmq.io.SysMessageID;
import com.sun.messaging.jmq.jmsserver.core.Destination;
import com.sun.messaging.jmq.jmsserver.core.DestinationList;
import com.sun.messaging.jmq.jmsserver.core.PacketReference;
import com.sun.messaging.jmq.jmsserver.data.handlers.admin.AdminCmdHandler;
import com.sun.messaging.jmq.jmsserver.data.handlers.admin.AdminDataHandler;
import com.sun.messaging.jmq.jmsserver.service.imq.IMQConnection;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import com.sun.messaging.jmq.jmsserver.util.lists.RemoveReason;
import com.sun.messaging.jmq.util.DestType;
import java.io.IOException;
import java.util.Hashtable;

public class DeleteMessageHandler
extends AdminCmdHandler {
    private static boolean DEBUG = DeleteMessageHandler.getDEBUG();

    public DeleteMessageHandler(AdminDataHandler parent) {
        super(parent);
    }

    @Override
    public boolean handle(IMQConnection con, Packet cmd_msg, Hashtable cmd_props) {
        if (DEBUG) {
            this.logger.log(4, this.getClass().getName() + ": Getting messages: " + cmd_props);
        }
        int status = 200;
        String errMsg = null;
        String destination = (String)cmd_props.get("JMQDestination");
        Integer destType = (Integer)cmd_props.get("JMQDestType");
        String msgID = (String)cmd_props.get("JMQMessageID");
        if (destType == null) {
            errMsg = "DELETE_MESSAGE: destination type not specified";
            this.logger.log(32, errMsg);
            status = 400;
        }
        if (status == 200) {
            try {
                this.deleteMessage(msgID, destination, DestType.isQueue((int)destType));
            }
            catch (Exception e) {
                status = 500;
                errMsg = e.getMessage();
                boolean logstack = true;
                if (e instanceof BrokerException && ((status = ((BrokerException)e).getStatusCode()) == 405 || status == 404 || status == 409 || status == 400)) {
                    logstack = false;
                }
                Object[] args = new Object[]{"" + msgID, "" + destination, e.getMessage()};
                errMsg = this.rb.getKString("B4420", args);
                if (logstack) {
                    this.logger.logStack(32, errMsg, (Throwable)e);
                }
                this.logger.log(32, errMsg, (Throwable)e);
            }
        }
        Packet reply = new Packet(con.useDirectBuffers());
        reply.setPacketType(5);
        DeleteMessageHandler.setProperties(reply, 89, status, errMsg);
        this.parent.sendReply(con, cmd_msg, reply);
        return true;
    }

    public void deleteMessage(String msgID, String destination, boolean isQueue) throws BrokerException, IOException {
        if (destination == null) {
            String emsg = "DELETE_MESSAGE: destination name not specified";
            throw new BrokerException(emsg, 400);
        }
        if (msgID == null) {
            String emsg = "DELETE_MESSAGE: Message ID not specified";
            throw new BrokerException(emsg, 400);
        }
        Destination[] ds = DestinationList.getDestination(null, destination, isQueue);
        Destination d = ds[0];
        if (d == null) {
            String emsg = "DELETE_MESSAGE: " + this.rb.getString("B4017", destination);
            throw new BrokerException(emsg, 404);
        }
        if (DEBUG) {
            d.debug();
        }
        this.logger.log(8, this.rb.getKString("B1454", msgID, d.getDestinationUID()));
        SysMessageID sysMsgID = SysMessageID.get((String)msgID);
        PacketReference pr = DestinationList.get(d.getPartitionedStore(), sysMsgID);
        if (pr == null) {
            String emsg = "Could not locate message " + msgID + " in destination " + destination;
            throw new BrokerException(emsg, 404);
        }
        if (!pr.isLocal()) {
            Object[] args = new Object[]{msgID, d.getDestinationUID(), pr.getBrokerAddress()};
            String emsg = this.rb.getKString("B3304", args);
            throw new BrokerException(emsg, 405);
        }
        Destination.RemoveMessageReturnInfo ret = d.removeMessageWithReturnInfo(sysMsgID, RemoveReason.REMOVE_ADMIN);
        if (ret.inreplacing) {
            String emsg = this.rb.getKString("B3308", msgID, d.getDestinationUID());
            throw new BrokerException(emsg, 409);
        }
        if (ret.indelivery) {
            String emsg = this.rb.getKString("B4422", msgID, d.getDestinationUID());
            throw new BrokerException(emsg, 409);
        }
        this.logger.log(8, this.rb.getKString("B1457", msgID, d.getDestinationUID()));
    }
}

