/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.core;

import com.sun.messaging.jmq.io.Packet;
import com.sun.messaging.jmq.io.SysMessageID;
import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.core.BrokerAddress;
import com.sun.messaging.jmq.jmsserver.core.Consumer;
import com.sun.messaging.jmq.jmsserver.core.ConsumerUID;
import com.sun.messaging.jmq.jmsserver.core.Destination;
import com.sun.messaging.jmq.jmsserver.core.DestinationList;
import com.sun.messaging.jmq.jmsserver.core.PacketReference;
import com.sun.messaging.jmq.jmsserver.core.Session;
import com.sun.messaging.jmq.jmsserver.data.TransactionBroker;
import com.sun.messaging.jmq.jmsserver.data.TransactionList;
import com.sun.messaging.jmq.jmsserver.data.TransactionState;
import com.sun.messaging.jmq.jmsserver.data.TransactionUID;
import com.sun.messaging.jmq.jmsserver.persist.api.NoPersistPartitionedStoreImpl;
import com.sun.messaging.jmq.jmsserver.persist.api.PartitionedStore;
import com.sun.messaging.jmq.jmsserver.plugin.spi.ConsumerSpi;
import com.sun.messaging.jmq.jmsserver.plugin.spi.SessionOpSpi;
import com.sun.messaging.jmq.jmsserver.service.Connection;
import com.sun.messaging.jmq.jmsserver.service.imq.IMQConnection;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import com.sun.messaging.jmq.jmsserver.util.lists.RemoveReason;
import com.sun.messaging.jmq.util.JMQXid;
import com.sun.messaging.jmq.util.lists.Prioritized;
import com.sun.messaging.jmq.util.lists.Reason;
import com.sun.messaging.jmq.util.lists.SubSet;
import com.sun.messaging.jmq.util.log.Logger;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;

public class SessionOp
extends SessionOpSpi {
    private Logger logger = Globals.getLogger();
    private Map deliveredMessages;
    private Map cleanupList = new HashMap();
    private Map storeMap = new HashMap();
    private DestinationList DL = Globals.getDestinationList();
    private Set detachedRConsumerUIDs = Collections.synchronizedSet(new LinkedHashSet());

    private SessionOp(Session s) {
        super(s);
        this.deliveredMessages = Collections.synchronizedMap(new LinkedHashMap());
    }

    public static SessionOp newInstance(Session s) {
        return new SessionOp(s);
    }

    public ConsumerUID getStoredIDForDetatchedConsumer(ConsumerUID cuid) {
        return (ConsumerUID)this.storeMap.get(cuid);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Hashtable getDebugState() {
        Hashtable<String, Object> ht = new Hashtable<String, Object>();
        ht.put("TABLE", "SessionOp[" + this.session + "]");
        ht.put("PendingAcks(deliveredMessages)", String.valueOf(this.deliveredMessages.size()));
        if (this.deliveredMessages.size() > 0) {
            HashMap copyDelivered = null;
            int[] cuidCnt = null;
            Map map = this.deliveredMessages;
            synchronized (map) {
                copyDelivered = new HashMap(this.deliveredMessages);
            }
            List copyCuids = this.session.getConsumerUIDs();
            cuidCnt = new int[copyCuids.size()];
            for (ackEntry e : copyDelivered.values()) {
                int indx = copyCuids.indexOf(e.getConsumerUID());
                if (indx == -1) continue;
                int n = indx;
                cuidCnt[n] = cuidCnt[n] + 1;
            }
            Hashtable<String, String> m = new Hashtable<String, String>();
            for (int i = 0; i < copyCuids.size(); ++i) {
                if (cuidCnt[i] == 0) continue;
                ConsumerUID cuid = (ConsumerUID)copyCuids.get(i);
                m.put(String.valueOf(cuid.longValue()), String.valueOf(cuidCnt[i]));
            }
            if (!m.isEmpty()) {
                ht.put("PendingAcksByConsumer", m);
            }
        }
        return ht;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Vector getDebugMessages(boolean full) {
        Vector<String> v = new Vector<String>();
        Map map = this.deliveredMessages;
        synchronized (map) {
            for (ackEntry e : this.deliveredMessages.values()) {
                v.add(e.getDebugMessage(full));
            }
        }
        return v;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getPendingAcks(ConsumerUID uid) {
        ArrayList<SysMessageID> acks = new ArrayList<SysMessageID>();
        HashMap copyDelivered = new HashMap();
        Map map = this.deliveredMessages;
        synchronized (map) {
            if (this.deliveredMessages.size() == 0) {
                return acks;
            }
            copyDelivered.putAll(this.deliveredMessages);
        }
        for (ackEntry e : copyDelivered.values()) {
            if (!e.getConsumerUID().equals(uid)) continue;
            acks.add(e.getSysMessageID());
        }
        return acks;
    }

    @Override
    public void checkAckType(int type) throws BrokerException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean onMessageDelivery(ConsumerSpi con, Object msg) {
        Consumer consumer = (Consumer)con;
        PacketReference ref = (PacketReference)msg;
        ConsumerUID cuid = consumer.getConsumerUID();
        ConsumerUID suid = consumer.getStoredConsumerUID();
        ackEntry entry = null;
        if (!consumer.getConsumerUID().isNoAck()) {
            entry = new ackEntry(ref, cuid, suid);
            Map map = this.deliveredMessages;
            synchronized (map) {
                this.deliveredMessages.put(entry, entry);
            }
        }
        try {
            boolean store = !this.session.isAutoAck(cuid) || this.deliveredMessages.size() == 1;
            if (!ref.delivered(cuid, suid, !this.session.isUnsafeAck(cuid), store)) return true;
            try {
                Destination d = ref.getDestination();
                if (ref.isDead()) {
                    Packet pk = ref.getPacket();
                    if (pk == null) return true;
                    if (pk.getConsumerFlow()) return true;
                    ref.removeInDelivery(suid);
                    d.removeDeadMessage(ref);
                    Map map = this.deliveredMessages;
                    synchronized (map) {
                        this.deliveredMessages.remove(entry);
                    }
                    boolean bl = false;
                    return bl;
                }
                ref.removeInDelivery(suid);
                d.removeMessage(ref.getSysMessageID(), (Reason)RemoveReason.ACKNOWLEDGED, !ref.isExpired());
                Map map = this.deliveredMessages;
                synchronized (map) {
                    this.deliveredMessages.remove(entry);
                    return true;
                }
            }
            finally {
                ref.postAcknowledgedRemoval();
            }
        }
        catch (Exception ex) {
            this.logger.logStack(16, ex.getMessage(), (Throwable)ex);
            Map map = this.deliveredMessages;
            synchronized (map) {
                if (entry == null) return false;
                this.deliveredMessages.get(entry);
                return false;
            }
        }
    }

    @Override
    public String toString() {
        return "SessionOp[" + this.session + "]";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean detachConsumer(ConsumerSpi c, SysMessageID id, boolean idInTransaction, boolean redeliverPendingConsume, boolean redeliverAll, Connection conn) {
        if (Session.DEBUG || Session.DEBUG_CLUSTER_MSG) {
            this.logger.log(8, "detachConsumer(" + c + ", " + id + ", " + redeliverPendingConsume + ", " + redeliverAll + ", " + (Object)((Object)conn.getConnectionUID()) + ")");
        }
        Consumer con = (Consumer)c;
        ConsumerUID cuid = con.getConsumerUID();
        ConsumerUID suid = con.getStoredConsumerUID();
        LinkedHashSet<PacketReference> s = new LinkedHashSet<PacketReference>();
        HashMap remotePendings = new HashMap();
        boolean holdmsgs = false;
        TransactionList[] tls = DestinationList.getTransactionList(((IMQConnection)conn).getPartitionedStore());
        TransactionList translist = tls[0];
        TransactionUID tid = null;
        Map map = this.deliveredMessages;
        synchronized (map) {
            PacketReference pr;
            ackEntry val;
            boolean found;
            ackEntry startEntry = null;
            if (id != null) {
                ackEntry entry = new ackEntry(id, cuid);
                startEntry = (ackEntry)this.deliveredMessages.get(entry);
            }
            this.cleanupList.put(cuid, con.getParentList());
            this.storeMap.put(cuid, con.getStoredConsumerUID());
            Iterator itr = this.deliveredMessages.values().iterator();
            boolean bl = found = startEntry == null && id != null;
            while (!redeliverAll && !found && itr.hasNext()) {
                val = (ackEntry)itr.next();
                if (val == startEntry) {
                    found = true;
                }
                if (!val.storedcid.equals(suid) || !val.uid.equals(cuid)) continue;
                pr = val.getReference();
                tid = null;
                if ((this.session.isTransacted() || idInTransaction) && (tid = translist.getConsumedInTransaction(val.getSysMessageID(), val.uid)) == null) {
                    if (pr != null) {
                        pr.removeInDelivery(suid);
                        s.add(pr);
                        SessionOp.addRemotePendings(pr, val.storedcid, new TransactionUID(0L), remotePendings);
                    }
                    itr.remove();
                    continue;
                }
                if (pr != null) {
                    try {
                        pr.consumed(suid, !this.session.isUnsafeAck(cuid), this.session.isAutoAck(cuid));
                        val.markConsumed();
                    }
                    catch (Exception ex) {
                        Object[] args = new Object[]{"[" + pr + "," + suid + "]", cuid, ex.getMessage()};
                        this.logger.log(16, Globals.getBrokerResources().getKString("B2244", args), (Throwable)ex);
                    }
                }
                if (redeliverPendingConsume) {
                    if (pr != null) {
                        pr.removeInDelivery(suid);
                        s.add(pr);
                    }
                    itr.remove();
                    continue;
                }
                if (pr != null && !pr.isLocal() && this.session.isValid() && SessionOp.addRemotePendings(pr, val.storedcid, tid, remotePendings)) {
                    this.detachedRConsumerUIDs.add(val.uid);
                }
                holdmsgs = true;
            }
            while (itr.hasNext()) {
                val = (ackEntry)itr.next();
                if (!val.storedcid.equals(suid) || !val.uid.equals(cuid)) continue;
                pr = val.getReference();
                if (this.session.isTransacted() && (tid = translist.getConsumedInTransaction(val.getSysMessageID(), val.uid)) != null) {
                    if (pr != null && !pr.isLocal() && this.session.isValid() && SessionOp.addRemotePendings(pr, val.storedcid, tid, remotePendings)) {
                        this.detachedRConsumerUIDs.add(val.uid);
                    }
                    holdmsgs = true;
                    continue;
                }
                if (pr != null) {
                    pr.removeInDelivery(suid);
                    s.add(pr);
                }
                itr.remove();
                try {
                    if (pr == null) continue;
                    pr.removeDelivered(suid, false);
                }
                catch (Exception ex) {
                    this.logger.log(16, "Unable to consume " + suid + ":" + pr, (Throwable)ex);
                }
            }
        }
        con.destroyConsumer(s, remotePendings, con.tobeRecreated() || !this.session.isValid() && !this.session.isXATransacted(), false, true);
        if (!holdmsgs && this.session.isValid()) {
            map = this.deliveredMessages;
            synchronized (map) {
                this.cleanupList.remove(cuid);
                this.storeMap.remove(cuid);
            }
            return true;
        }
        return false;
    }

    private static boolean addRemotePendings(PacketReference pr, ConsumerUID suid, TransactionUID tid, Map pendings) {
        BrokerAddress ba = pr.getBrokerAddress();
        if (ba != null) {
            LinkedHashMap<SysMessageID, Integer> mm;
            HashMap<TransactionUID, LinkedHashMap<SysMessageID, Integer>> m = (HashMap<TransactionUID, LinkedHashMap<SysMessageID, Integer>>)pendings.get(ba);
            if (m == null) {
                m = new HashMap<TransactionUID, LinkedHashMap<SysMessageID, Integer>>();
                pendings.put(ba, m);
            }
            if ((mm = (LinkedHashMap<SysMessageID, Integer>)m.get(tid)) == null) {
                mm = new LinkedHashMap<SysMessageID, Integer>();
                m.put(tid, mm);
            }
            mm.put(pr.getSysMessageID(), pr.getRedeliverCount(suid));
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object ackInTransaction(ConsumerUID cuid, SysMessageID id, TransactionUID tuid, int deliverCnt) throws BrokerException {
        ackEntry entry = new ackEntry(id, cuid);
        Map map = this.deliveredMessages;
        synchronized (map) {
            entry = (ackEntry)this.deliveredMessages.get(entry);
        }
        if (entry == null) {
            String info = "Received unknown message for transaction " + tuid + " on session " + this.session + " ack info is " + cuid + "," + id;
            PacketReference m = DestinationList.get(null, id);
            info = m == null ? info + ": Broker does not know about the message" : info + ":Broker knows about the message, not associated with the session";
            this.logger.log(16, info);
            BrokerException bex = new BrokerException(info, 410);
            bex.setRemoteConsumerUIDs(String.valueOf(cuid.longValue()));
            bex.setRemote(true);
            throw bex;
        }
        if (entry.getTUID() != null && !entry.getTUID().equals(tuid)) {
            BrokerException bex = new BrokerException("Message requeued:" + entry.getReference(), 410);
            bex.setRemoteConsumerUIDs(String.valueOf(entry.getConsumerUID().longValue()));
            bex.setRemote(true);
            throw bex;
        }
        PacketReference ref = entry.getReference();
        if (ref == null) {
            throw new BrokerException(Globals.getBrokerResources().getKString("B1290", id) + "[" + cuid + ":" + entry.getStoredUID() + "]TUID=" + tuid, 409);
        }
        if (ref.isOverrided()) {
            BrokerException bex = new BrokerException("Message requeued:" + entry.getReference(), 410);
            bex.setRemoteConsumerUIDs(String.valueOf(entry.getConsumerUID().longValue()));
            bex.setRemote(true);
            throw bex;
        }
        entry.setTUID(tuid);
        if (deliverCnt > 0) {
            ref.updateForJMSXDeliveryCount(entry.getStoredUID(), deliverCnt, false);
        }
        return ref.getBrokerAddress();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean hasDeliveredMessages(ConsumerUID cuid) {
        ArrayList list = null;
        Map map = this.deliveredMessages;
        synchronized (map) {
            list = new ArrayList(this.deliveredMessages.values());
        }
        ackEntry entry = null;
        Iterator itr = list.iterator();
        while (this.session.isValid() && itr.hasNext()) {
            entry = (ackEntry)itr.next();
            if (!entry.getConsumerUID().equals(cuid)) continue;
            return true;
        }
        return !this.session.isValid();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close(Connection conn) {
        Object openMsgs;
        TransactionList[] tls = DestinationList.getTransactionList(((IMQConnection)conn).getPartitionedStore());
        TransactionList translist = tls[0];
        Map map = this.deliveredMessages;
        synchronized (map) {
            if (!this.deliveredMessages.isEmpty()) {
                openMsgs = new HashMap();
                Iterator itr = this.deliveredMessages.entrySet().iterator();
                while (itr.hasNext()) {
                    PacketReference ref;
                    Map.Entry entry = itr.next();
                    ackEntry e = (ackEntry)entry.getValue();
                    ConsumerUID cuid = e.getConsumerUID();
                    ConsumerUID storeduid = e.getStoredUID() == null ? cuid : e.getStoredUID();
                    TransactionUID tid = e.getTUID();
                    if (tid != null) {
                        JMQXid jmqxid = translist.UIDToXid(tid);
                        if (jmqxid != null) {
                            translist.addOrphanAck(tid, e.getSysMessageID(), storeduid, cuid);
                            itr.remove();
                            continue;
                        }
                        TransactionState ts = translist.retrieveState(tid, true);
                        if (ts != null && ts.getState() == 5) {
                            translist.addOrphanAck(tid, e.getSysMessageID(), storeduid, cuid);
                            itr.remove();
                            continue;
                        }
                        if (ts != null && ts.getState() == 6) {
                            itr.remove();
                            continue;
                        }
                        if (ts != null && ts.getState() == 4 && conn.getConnectionState() >= 6) {
                            Object[] args = new String[]{"" + tid, TransactionState.toString(ts.getState()), this.session.getConnectionUID().toString()};
                            this.logger.log(8, Globals.getBrokerResources().getKString("B1266", args));
                            translist.addOrphanAck(tid, e.getSysMessageID(), storeduid, cuid);
                            itr.remove();
                            continue;
                        }
                    }
                    if ((ref = e.getReference()) == null) {
                        ref = DestinationList.get(null, e.getSysMessageID());
                    }
                    if (ref != null && !ref.isLocal()) {
                        itr.remove();
                        try {
                            ref = e.acknowledged(false);
                            if (ref == null) continue;
                            try {
                                Destination d = ref.getDestination();
                                d.removeRemoteMessage(ref.getSysMessageID(), RemoveReason.ACKNOWLEDGED, ref);
                            }
                            finally {
                                ref.postAcknowledgedRemoval();
                            }
                        }
                        catch (Exception ex) {
                            this.logger.logStack(Session.DEBUG_CLUSTER_MSG ? 16 : 4, "Unable to clean up remote message " + e.getDebugMessage(false), (Throwable)ex);
                        }
                        continue;
                    }
                    LinkedHashSet<ackEntry> s = (LinkedHashSet<ackEntry>)((HashMap)openMsgs).get(cuid);
                    if (s == null) {
                        s = new LinkedHashSet<ackEntry>();
                        ((HashMap)openMsgs).put(cuid, s);
                    }
                    if (ref != null) {
                        ref.removeInDelivery(storeduid);
                    }
                    s.add(e);
                }
                itr = ((HashMap)openMsgs).entrySet().iterator();
                Map.Entry pair = null;
                while (itr.hasNext()) {
                    pair = itr.next();
                    ConsumerUID cuid = (ConsumerUID)pair.getKey();
                    Map parentmp = (Map)this.cleanupList.get(cuid);
                    ConsumerUID suid = (ConsumerUID)this.storeMap.get(cuid);
                    if (parentmp == null || parentmp.size() == 0) {
                        Set s = (Set)pair.getValue();
                        for (ackEntry e : s) {
                            try {
                                PacketReference ref = e.acknowledged(false);
                                if (ref == null) continue;
                                try {
                                    Destination d = ref.getDestination();
                                    try {
                                        if (ref.isLocal()) {
                                            d.removeMessage(ref.getSysMessageID(), RemoveReason.ACKNOWLEDGED);
                                            continue;
                                        }
                                        d.removeRemoteMessage(ref.getSysMessageID(), RemoveReason.ACKNOWLEDGED, ref);
                                    }
                                    catch (Exception ex) {
                                        Object[] args = new Object[]{ref, this, ex.getMessage()};
                                        this.logger.logStack(16, Globals.getBrokerResources().getKString("B4443", args), (Throwable)ex);
                                    }
                                }
                                finally {
                                    ref.postAcknowledgedRemoval();
                                }
                            }
                            catch (Exception ref) {}
                        }
                        continue;
                    }
                    LinkedHashMap<PartitionedStore, LinkedHashSet<PacketReference>> mp = new LinkedHashMap<PartitionedStore, LinkedHashSet<PacketReference>>();
                    LinkedHashSet<PacketReference> msgs = null;
                    PartitionedStore ps = null;
                    Set s = (Set)((HashMap)openMsgs).get(cuid);
                    Iterator sitr = s.iterator();
                    while (sitr.hasNext()) {
                        ackEntry e = (ackEntry)sitr.next();
                        PacketReference ref = e.getReference();
                        if (ref != null) {
                            try {
                                if (!e.hasMarkConsumed()) {
                                    ref.consumed(suid, !this.session.isUnsafeAck(cuid), this.session.isAutoAck(cuid));
                                }
                            }
                            catch (Exception ex) {
                                this.logger.logStack(16, "Unable to consume " + suid + ":" + ref, (Throwable)ex);
                            }
                            ps = ref.getPartitionedStore();
                            if (!ref.getDestinationUID().isQueue()) {
                                ps = new NoPersistPartitionedStoreImpl(suid);
                            }
                            if ((msgs = (LinkedHashSet<PacketReference>)mp.get(ps)) == null) {
                                msgs = new LinkedHashSet<PacketReference>();
                                mp.put(ps, msgs);
                            }
                            msgs.add(ref);
                            continue;
                        }
                        sitr.remove();
                    }
                    SubSet pl = null;
                    itr = mp.entrySet().iterator();
                    pair = null;
                    while (itr.hasNext()) {
                        pair = itr.next();
                        ps = (PartitionedStore)pair.getKey();
                        pl = (SubSet)parentmp.get(ps);
                        if (pl != null) {
                            ((Prioritized)pl).addAllOrdered((Collection)((Set)pair.getValue()));
                            continue;
                        }
                        this.logger.log(16, "Message(s) " + mp.get(ps) + "[" + suid + ", " + cuid + "] parentlist not found on session closing");
                    }
                }
                this.deliveredMessages.clear();
                this.cleanupList.clear();
                this.storeMap.clear();
            }
        }
        if (!this.session.isXATransacted()) {
            Iterator itr = null;
            openMsgs = this.detachedRConsumerUIDs;
            synchronized (openMsgs) {
                itr = new LinkedHashSet(this.detachedRConsumerUIDs).iterator();
            }
            while (itr.hasNext()) {
                Consumer c = Consumer.newInstance((ConsumerUID)itr.next());
                try {
                    Globals.getClusterBroadcast().destroyConsumer(c, null, true);
                }
                catch (Exception e) {
                    this.logger.log(16, "Unable to send consumer [" + c + "] cleanup notification for closing of SessionOp[" + this + "].");
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object handleUndeliverable(ConsumerSpi con, SysMessageID id, int deliverCnt, boolean deliverCntUpdateOnly) throws BrokerException {
        Consumer c = (Consumer)con;
        ConsumerUID cuid = c.getConsumerUID();
        ackEntry entry = new ackEntry(id, cuid);
        PacketReference ref = null;
        Map map = this.deliveredMessages;
        synchronized (map) {
            entry = (ackEntry)this.deliveredMessages.remove(entry);
        }
        if (entry == null) {
            return null;
        }
        ref = entry.getReference();
        if (ref == null) {
            return null;
        }
        ConsumerUID storedid = c.getStoredConsumerUID();
        if (deliverCntUpdateOnly) {
            ref.updateForJMSXDeliveryCount(storedid, deliverCnt, false);
            return null;
        }
        if (storedid.equals(cuid)) {
            try {
                if (ref.acknowledged(cuid, storedid, false, false)) {
                    return ref;
                }
            }
            catch (Exception ex) {
                this.logger.logStack(4, "Error handling undeliverable", (Throwable)ex);
            }
            return null;
        }
        Destination d = ref.getDestination();
        if (ref.isLocal()) {
            d.forwardOrphanMessage(ref, storedid);
        } else if (ref.markDead(cuid, storedid, null, null, RemoveReason.UNDELIVERABLE, -1, null)) {
            return ref;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object handleDead(ConsumerSpi con, SysMessageID id, RemoveReason deadReason, Throwable thr, String comment, int deliverCnt) throws BrokerException {
        Consumer c = (Consumer)con;
        ConsumerUID cuid = c.getConsumerUID();
        ackEntry entry = new ackEntry(id, cuid);
        PacketReference ref = null;
        Map map = this.deliveredMessages;
        synchronized (map) {
            entry = (ackEntry)this.deliveredMessages.remove(entry);
        }
        if (entry == null) {
            return null;
        }
        ref = entry.getReference();
        if (ref == null) {
            return null;
        }
        ConsumerUID storedid = c.getStoredConsumerUID();
        Destination d = ref.getDestination();
        if (ref.markDead(cuid, storedid, comment, thr, deadReason, deliverCnt, null)) {
            return ref;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object ackMessage(ConsumerUID cuid, SysMessageID id, TransactionUID tuid, Object translist, HashMap remoteNotified, boolean ackack) throws BrokerException {
        ackEntry entry = new ackEntry(id, cuid);
        PacketReference ref = null;
        Map map = this.deliveredMessages;
        synchronized (map) {
            entry = (ackEntry)this.deliveredMessages.remove(entry);
        }
        if (entry == null) {
            String emsg = null;
            emsg = !this.session.isValid() ? Globals.getBrokerResources().getKString("B2291", id + "[" + cuid + "]TID=" + tuid) : (tuid == null ? Globals.getBrokerResources().getKString("B2212", id + "[" + cuid + "]") : Globals.getBrokerResources().getKString("B2213", tuid.toString(), id + "[" + cuid + "]"));
            this.logger.log(16, emsg);
            throw new BrokerException(emsg, 409);
        }
        ref = entry.acknowledged(true, tuid, (TransactionList)translist, remoteNotified, ackack);
        return ref;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void postAckMessage(ConsumerUID cuid, SysMessageID id, boolean ackack) {
        if (this.session.isAutoAck(cuid)) {
            Map map = this.deliveredMessages;
            synchronized (map) {
                Iterator itr = this.deliveredMessages.values().iterator();
                while (itr.hasNext()) {
                    ackEntry e = (ackEntry)itr.next();
                    PacketReference newref = e.getReference();
                    if (newref == null) {
                        newref = DestinationList.get(null, id);
                        if (newref == null) {
                            this.logger.log(2, "Removing gone reference " + e);
                        } else {
                            this.logger.log(8, "Reference still exists despite null in session ack entry: " + newref);
                            try {
                                PacketReference pr = e.acknowledged(true, ackack);
                                if (pr != null) {
                                    pr.postAcknowledgedRemoval();
                                }
                            }
                            catch (Exception pr) {
                                // empty catch block
                            }
                        }
                        itr.remove();
                        continue;
                    }
                    try {
                        newref.delivered(e.getConsumerUID(), e.getStoredUID(), true, newref.isStored());
                        break;
                    }
                    catch (Exception ex) {
                        this.logger.logStack(16, Globals.getBrokerResources().getKString("B2263", newref + "[" + cuid + "]", ex.getMessage()), (Throwable)ex);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean acknowledgeToMessage(ConsumerUID cuid, SysMessageID id, boolean ackack) throws BrokerException {
        boolean removed = false;
        ackEntry entry = new ackEntry(id, cuid);
        Map map = this.deliveredMessages;
        synchronized (map) {
            ackEntry value = (ackEntry)this.deliveredMessages.get(entry);
            if (value == null) {
                assert (false) : entry;
                return false;
            }
            Iterator itr = this.deliveredMessages.values().iterator();
            while (itr.hasNext()) {
                ackEntry val = (ackEntry)itr.next();
                PacketReference ref = val.acknowledged(true, ackack);
                if (ref != null) {
                    try {
                        Destination d = ref.getDestination();
                        try {
                            d.removeMessage(ref.getSysMessageID(), RemoveReason.ACKNOWLEDGED);
                        }
                        catch (Exception ex) {
                            this.logger.logStack(16, ex.getMessage(), (Throwable)ex);
                        }
                    }
                    finally {
                        ref.postAcknowledgedRemoval();
                    }
                }
                itr.remove();
                removed = true;
                if (!val.equals(value)) continue;
                break;
            }
        }
        return removed;
    }

    class ackEntry {
        ConsumerUID uid = null;
        ConsumerUID storedcid = null;
        Object pref = null;
        SysMessageID id = null;
        TransactionUID tuid = null;
        int hc = 0;
        boolean markConsumed = false;

        public ackEntry(SysMessageID id, ConsumerUID uid) {
            assert (id != null);
            assert (uid != null);
            this.id = id;
            this.uid = uid;
            this.pref = null;
        }

        public String toString() {
            return this.id + "[" + this.uid + "," + this.storedcid + "]" + (this.tuid == null ? "" : "TUID=" + this.tuid);
        }

        public boolean hasMarkConsumed() {
            return this.markConsumed;
        }

        public void markConsumed() {
            this.markConsumed = true;
        }

        public String getDebugMessage(boolean full) {
            PacketReference ref = this.getReference();
            Packet p = ref == null ? null : ref.getPacket();
            String str = "[" + this.uid + "," + this.storedcid + "," + (p == null ? "null" : p.toString()) + "]";
            if (full && p != null) {
                str = str + "\n" + p.dumpPacketString(">>");
            }
            return str;
        }

        public void setTUID(TransactionUID uid) {
            this.tuid = uid;
        }

        public TransactionUID getTUID() {
            return this.tuid;
        }

        public ConsumerUID getConsumerUID() {
            return this.uid;
        }

        public ConsumerUID getStoredUID() {
            return this.storedcid;
        }

        public SysMessageID getSysMessageID() {
            return this.id;
        }

        public PacketReference getReference() {
            if (this.pref instanceof WeakReference) {
                return (PacketReference)((WeakReference)this.pref).get();
            }
            return (PacketReference)this.pref;
        }

        public ackEntry(PacketReference ref, ConsumerUID uid, ConsumerUID storedUID) {
            this.pref = ref.isLocal() ? new WeakReference<PacketReference>(ref) : ref;
            this.id = ref.getSysMessageID();
            this.storedcid = storedUID;
            this.uid = uid;
        }

        public PacketReference acknowledged(boolean notify) throws BrokerException {
            return this.acknowledged(notify, null, null, null, true);
        }

        public PacketReference acknowledged(boolean notify, boolean ackack) throws BrokerException {
            return this.acknowledged(notify, null, null, null, ackack);
        }

        public PacketReference acknowledged(boolean notify, TransactionUID tid, TransactionList translist, HashMap<TransactionBroker, Object> remoteNotified, boolean ackack) throws BrokerException {
            assert (this.pref != null);
            boolean rm = false;
            PacketReference ref = this.getReference();
            try {
                if (ref != null && ref.isOverrided()) {
                    BrokerException bex = new BrokerException("Message requeued:" + ref, 410);
                    bex.setRemoteConsumerUIDs(String.valueOf(this.getConsumerUID().longValue()));
                    bex.setRemote(true);
                    throw bex;
                }
                if (ref == null) {
                    SessionOp.this.DL;
                    ref = DestinationList.get(null, this.id);
                }
                if (ref == null) {
                    String emsg = null;
                    emsg = tid == null ? Globals.getBrokerResources().getKString("B2212", this.toString()) : Globals.getBrokerResources().getKString("B2213", tid.toString(), this.toString());
                    SessionOp.this.logger.log(16, emsg);
                    throw new BrokerException(emsg, 409);
                }
                rm = ref.acknowledged(this.uid, this.storedcid, !SessionOp.this.session.isUnsafeAck(this.uid), notify, tid, translist, remoteNotified, ackack);
                Consumer c = (Consumer)SessionOp.this.session.getConsumerOnSession(this.uid);
                if (c != null) {
                    c.setLastAckTime(System.currentTimeMillis());
                }
            }
            catch (Exception ex) {
                assert (false) : ref;
                String emsg = Globals.getBrokerResources().getKString("B4361", this.toString() + "[" + ref.getDestinationUID() + "]", ex.getMessage());
                if (SessionOp.this.logger.getLevel() <= 4) {
                    SessionOp.this.logger.logStack(4, emsg, (Throwable)ex);
                } else {
                    SessionOp.this.logger.log(16, emsg);
                }
                if (ex instanceof BrokerException) {
                    throw (BrokerException)ex;
                }
                throw new BrokerException(emsg, ex);
            }
            return rm ? ref : null;
        }

        public boolean equals(Object o) {
            if (!(o instanceof ackEntry)) {
                return false;
            }
            ackEntry ak = (ackEntry)o;
            return this.uid.equals(ak.uid) && this.id.equals((Object)ak.id);
        }

        public int hashCode() {
            if (this.hc == 0) {
                this.hc = this.id.hashCode() * 15 + this.uid.hashCode();
            }
            return this.hc;
        }
    }
}

