/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.security.openid.controller;

import com.nimbusds.jose.proc.SecurityContext;
import com.nimbusds.jwt.JWTClaimsSet;
import com.nimbusds.jwt.proc.BadJWTException;
import com.nimbusds.jwt.proc.JWTClaimsSetVerifier;
import fish.payara.security.openid.domain.OpenIdConfiguration;
import java.util.Date;
import java.util.List;
import java.util.Objects;

public abstract class TokenClaimsSetVerifier
implements JWTClaimsSetVerifier {
    protected final OpenIdConfiguration configuration;

    public TokenClaimsSetVerifier(OpenIdConfiguration configuration) {
        this.configuration = configuration;
    }

    public void verify(JWTClaimsSet claims, SecurityContext c) throws BadJWTException {
        int clockSkewInSeconds = 60;
        int clockSkewInMillis = clockSkewInSeconds * 1000;
        if (Objects.isNull(claims.getIssuer())) {
            throw new IllegalStateException("Missing issuer (iss) claim");
        }
        if (!claims.getIssuer().equals(this.configuration.getProviderMetadata().getIssuerURI())) {
            throw new IllegalStateException("Invalid issuer : " + this.configuration.getProviderMetadata().getIssuerURI());
        }
        if (Objects.isNull(claims.getSubject())) {
            throw new IllegalStateException("Missing subject (sub) claim");
        }
        List audience = claims.getAudience();
        if (Objects.isNull(audience) || audience.isEmpty()) {
            throw new IllegalStateException("Missing audience (aud) claim");
        }
        if (!audience.contains(this.configuration.getClientId())) {
            throw new IllegalStateException("Invalid audience (aud) claim " + audience);
        }
        Object authorizedParty = claims.getClaim("azp");
        if (audience.size() > 1 && Objects.isNull(authorizedParty)) {
            throw new IllegalStateException("Missing authorized party (azp) claim");
        }
        if (audience.size() > 1 && Objects.nonNull(authorizedParty) && !authorizedParty.equals(this.configuration.getClientId())) {
            throw new IllegalStateException("Invalid authorized party (azp) claim " + this.configuration.getClientId());
        }
        long currentTime = System.currentTimeMillis();
        Date exp = claims.getExpirationTime();
        if (Objects.isNull(exp)) {
            throw new IllegalStateException("Missing expiration time (exp) claim");
        }
        if (exp.getTime() + (long)clockSkewInMillis < currentTime) {
            throw new IllegalStateException("Token is expired " + exp);
        }
        Date iat = claims.getIssueTime();
        if (Objects.isNull(iat)) {
            throw new IllegalStateException("Missing issue time (iat) claim");
        }
        if (iat.getTime() - (long)clockSkewInMillis > currentTime) {
            throw new IllegalStateException("Issue time must be after current time " + iat);
        }
        this.verify(claims);
    }

    public abstract void verify(JWTClaimsSet var1) throws BadJWTException;
}

