/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.microprofile.faulttolerance.state;

import fish.payara.microprofile.faulttolerance.state.StateTime;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;

public class CircuitBreakerState {
    private static final Logger logger = Logger.getLogger(CircuitBreakerState.class.getName());
    private final int failureThreshold;
    private final AtomicInteger halfOpenSuccessfulResultsCounter = new AtomicInteger(0);
    private final Map<CircuitState, StateTime> allStateTimes = new ConcurrentHashMap<CircuitState, StateTime>(CircuitState.values().length);
    private volatile StateTime currentStateTime;
    private final boolean[] failureBuffer;
    private int failureIndex = 0;
    private long outcomeUpdates = 0L;

    public CircuitBreakerState(int requestVolumeThreshold, double failureRatio) {
        this.failureBuffer = new boolean[Math.max(0, requestVolumeThreshold)];
        this.failureThreshold = (int)Math.round((double)requestVolumeThreshold * failureRatio);
        for (CircuitState state : CircuitState.values()) {
            this.allStateTimes.put(state, new StateTime(state));
        }
        this.currentStateTime = this.allStateTimes.get((Object)CircuitState.CLOSED);
    }

    public CircuitState getCircuitState() {
        return this.currentStateTime.state();
    }

    public void setCircuitState(CircuitState circuitState) {
        this.currentStateTime.update();
        if (!this.currentStateTime.is(circuitState)) {
            StateTime nextStateTime = this.allStateTimes.get((Object)circuitState);
            nextStateTime.reset();
            this.currentStateTime = nextStateTime;
        }
    }

    public synchronized void recordClosedOutcome(boolean success) {
        this.failureBuffer[this.failureIndex] = !success;
        this.failureIndex = (this.failureIndex + 1) % this.failureBuffer.length;
        ++this.outcomeUpdates;
    }

    public synchronized boolean isClosedOutcomeSuccessOnly() {
        if (this.failureBuffer.length == 0 || this.outcomeUpdates < (long)this.failureBuffer.length) {
            return false;
        }
        for (boolean failure : this.failureBuffer) {
            if (!failure) continue;
            return false;
        }
        return true;
    }

    public synchronized void resetResults() {
        this.failureIndex = 0;
        this.outcomeUpdates = 0L;
    }

    public void incrementHalfOpenSuccessfulResultCounter() {
        this.halfOpenSuccessfulResultsCounter.incrementAndGet();
    }

    public void resetHalfOpenSuccessfulResultCounter() {
        this.halfOpenSuccessfulResultsCounter.set(0);
    }

    public int getHalfOpenSuccessfulResultCounter() {
        return this.halfOpenSuccessfulResultsCounter.get();
    }

    public synchronized boolean isOverFailureThreshold() {
        if (this.outcomeUpdates < (long)this.failureBuffer.length) {
            logger.log(Level.FINE, "CircuitBreaker results queue isn't full yet.");
            return false;
        }
        int failures = 0;
        for (boolean failure : this.failureBuffer) {
            if (!failure || ++failures < this.failureThreshold) continue;
            return true;
        }
        return false;
    }

    public long updateAndGet(CircuitState circuitState) {
        return this.currentStateTime.is(circuitState) ? this.currentStateTime.update() : this.allStateTimes.get((Object)circuitState).nanos();
    }

    public long nanosOpen() {
        return this.updateAndGet(CircuitState.OPEN);
    }

    public long nanosHalfOpen() {
        return this.updateAndGet(CircuitState.HALF_OPEN);
    }

    public long nanosClosed() {
        return this.updateAndGet(CircuitState.CLOSED);
    }

    public void close() {
        this.setCircuitState(CircuitState.CLOSED);
        this.resetHalfOpenSuccessfulResultCounter();
        this.resetResults();
    }

    public void open() {
        this.setCircuitState(CircuitState.OPEN);
        this.resetHalfOpenSuccessfulResultCounter();
    }

    public void halfOpen() {
        logger.log(Level.FINE, "Setting CircuitBreaker state to half open");
        this.setCircuitState(CircuitState.HALF_OPEN);
    }

    public boolean halfOpenSuccessfulClosedCircuit(int successThreshold) {
        this.incrementHalfOpenSuccessfulResultCounter();
        if (this.getHalfOpenSuccessfulResultCounter() == successThreshold) {
            this.close();
            return true;
        }
        return false;
    }

    public static enum CircuitState {
        OPEN,
        CLOSED,
        HALF_OPEN;

    }
}

