/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.microprofile.faulttolerance.service;

import fish.payara.microprofile.faulttolerance.FaultToleranceMethodContext;
import fish.payara.microprofile.faulttolerance.FaultToleranceMetrics;
import fish.payara.microprofile.faulttolerance.policy.FaultTolerancePolicy;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import java.util.function.LongSupplier;
import org.eclipse.microprofile.metrics.Counter;
import org.eclipse.microprofile.metrics.Histogram;
import org.eclipse.microprofile.metrics.Metadata;
import org.eclipse.microprofile.metrics.MetricID;
import org.eclipse.microprofile.metrics.MetricRegistry;
import org.eclipse.microprofile.metrics.MetricType;
import org.eclipse.microprofile.metrics.Tag;

public final class MethodFaultToleranceMetrics
implements FaultToleranceMetrics {
    private final MetricRegistry registry;
    private final String canonicalMethodName;
    private final AtomicBoolean registered;
    private final Map<MetricID, Counter> countersByMetricID;
    private final Map<MetricID, Histogram> histogramsByMetricID;
    private FaultToleranceMetrics.FallbackUsage fallbackUsage;
    private boolean retried;

    public MethodFaultToleranceMetrics(MetricRegistry registry, String canonicalMethodName) {
        this(registry, canonicalMethodName, FaultToleranceMetrics.FallbackUsage.notDefined, new AtomicBoolean(), new ConcurrentHashMap<MetricID, Counter>(), new ConcurrentHashMap<MetricID, Histogram>());
    }

    private MethodFaultToleranceMetrics(MetricRegistry registry, String canonicalMethodName, FaultToleranceMetrics.FallbackUsage fallbackUsage, AtomicBoolean registered, Map<MetricID, Counter> countersByMetricID, Map<MetricID, Histogram> histogramsByMetricID) {
        this.registry = registry;
        this.canonicalMethodName = canonicalMethodName;
        this.fallbackUsage = fallbackUsage;
        this.registered = registered;
        this.countersByMetricID = countersByMetricID;
        this.histogramsByMetricID = histogramsByMetricID;
    }

    @Override
    public synchronized FaultToleranceMetrics boundTo(FaultToleranceMethodContext context, FaultTolerancePolicy policy) {
        if (this.registered.compareAndSet(false, true)) {
            FaultToleranceMetrics.super.boundTo(context, policy);
        }
        return new MethodFaultToleranceMetrics(this.registry, this.canonicalMethodName, policy.isFallbackPresent() ? FaultToleranceMetrics.FallbackUsage.notApplied : FaultToleranceMetrics.FallbackUsage.notDefined, this.registered, this.countersByMetricID, this.histogramsByMetricID);
    }

    @Override
    public void register(MetricType type, String metric, String[] ... tagsPermutations) {
        if (type == MetricType.COUNTER) {
            MethodFaultToleranceMetrics.registerPermutations(tagsPermutations, tags -> this.countersByMetricID.computeIfAbsent(this.withMethodTag(metric, (Tag[])tags), key -> this.registry.counter(key)));
        } else if (type == MetricType.HISTOGRAM) {
            MethodFaultToleranceMetrics.registerPermutations(tagsPermutations, tags -> this.histogramsByMetricID.computeIfAbsent(this.withMethodTag(metric, (Tag[])tags), key -> this.registry.histogram(MethodFaultToleranceMetrics.withUnit(key, "nanoseconds"), key.getTagsAsArray())));
        } else {
            throw new UnsupportedOperationException("Only counter and histogram are supported but got: " + type);
        }
    }

    @Override
    public void register(String metric, String unit, LongSupplier gauge, String ... tag) {
        MetricID key = this.withMethodTag(metric, MethodFaultToleranceMetrics.asTag(tag));
        if (unit == null || "none".equals(unit)) {
            this.registry.gauge(key, () -> gauge.getAsLong());
        } else {
            this.registry.gauge(MethodFaultToleranceMetrics.withUnit(key, unit), () -> gauge.getAsLong(), key.getTagsAsArray());
        }
    }

    private static void registerPermutations(String[][] tags, Consumer<Tag[]> register) {
        if (tags.length == 0) {
            register.accept(NO_TAGS);
            return;
        }
        if (tags.length == 1) {
            String[] tag1 = tags[0];
            for (int i = 1; i < tag1.length; ++i) {
                register.accept(new Tag[]{new Tag(tag1[0], tag1[i])});
            }
            return;
        }
        if (tags.length == 2) {
            String[] tag1 = tags[0];
            String[] tag2 = tags[1];
            for (int i = 1; i < tag1.length; ++i) {
                for (int j = 1; j < tag2.length; ++j) {
                    register.accept(new Tag[]{new Tag(tag1[0], tag1[i]), new Tag(tag2[0], tag2[j])});
                }
            }
            return;
        }
        throw new UnsupportedOperationException("Only 0 to 2 tags supported but got: " + tags.length);
    }

    private static Tag[] asTag(String ... tag) {
        Tag[] tagArray;
        if (tag.length == 0) {
            tagArray = NO_TAGS;
        } else {
            Tag[] tagArray2 = new Tag[1];
            tagArray = tagArray2;
            tagArray2[0] = new Tag(tag[0], tag[1]);
        }
        return tagArray;
    }

    @Override
    public void incrementCounter(String metric, Tag ... tags) {
        this.countersByMetricID.get(this.withMethodTag(metric, tags)).inc();
    }

    @Override
    public void addToHistogram(String metric, long duration, Tag ... tags) {
        this.histogramsByMetricID.get(this.withMethodTag(metric, tags)).update(duration);
    }

    private static Metadata withUnit(MetricID key, String unit) {
        return Metadata.builder().withName(key.getName()).withUnit(unit).build();
    }

    private MetricID withMethodTag(String metric, Tag[] tags) {
        Tag method = new Tag("method", this.canonicalMethodName);
        if (tags.length == 0) {
            return new MetricID(metric, new Tag[]{method});
        }
        Tag[] newTags = new Tag[tags.length + 1];
        newTags[0] = method;
        System.arraycopy(tags, 0, newTags, 1, tags.length);
        return new MetricID(metric, newTags);
    }

    @Override
    public FaultToleranceMetrics.FallbackUsage getFallbackUsage() {
        return this.fallbackUsage;
    }

    @Override
    public void incrementFallbackCallsTotal() {
        this.fallbackUsage = FaultToleranceMetrics.FallbackUsage.applied;
    }

    @Override
    public void incrementRetryRetriesTotal() {
        this.retried = true;
        FaultToleranceMetrics.super.incrementRetryRetriesTotal();
    }

    @Override
    public boolean isRetried() {
        return this.retried;
    }
}

