/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.microprofile.faulttolerance.cdi;

import fish.payara.microprofile.faulttolerance.FaultToleranceConfig;
import fish.payara.microprofile.faulttolerance.cdi.FaultToleranceInterceptor;
import fish.payara.microprofile.faulttolerance.policy.FaultTolerancePolicy;
import fish.payara.microprofile.faulttolerance.service.FaultToleranceUtils;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.time.temporal.ChronoUnit;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Priority;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.spi.AfterBeanDiscovery;
import javax.enterprise.inject.spi.AfterTypeDiscovery;
import javax.enterprise.inject.spi.Annotated;
import javax.enterprise.inject.spi.AnnotatedMethod;
import javax.enterprise.inject.spi.AnnotatedType;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanAttributes;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.BeforeBeanDiscovery;
import javax.enterprise.inject.spi.Extension;
import javax.enterprise.inject.spi.InjectionPoint;
import javax.enterprise.inject.spi.InjectionTarget;
import javax.enterprise.inject.spi.InterceptionType;
import javax.enterprise.inject.spi.Interceptor;
import javax.enterprise.inject.spi.ProcessAnnotatedType;
import javax.enterprise.inject.spi.WithAnnotations;
import javax.enterprise.inject.spi.configurator.AnnotatedMethodConfigurator;
import javax.interceptor.InvocationContext;
import org.eclipse.microprofile.config.ConfigProvider;
import org.eclipse.microprofile.faulttolerance.Asynchronous;
import org.eclipse.microprofile.faulttolerance.Bulkhead;
import org.eclipse.microprofile.faulttolerance.CircuitBreaker;
import org.eclipse.microprofile.faulttolerance.Fallback;
import org.eclipse.microprofile.faulttolerance.FallbackHandler;
import org.eclipse.microprofile.faulttolerance.Retry;
import org.eclipse.microprofile.faulttolerance.Timeout;

public class FaultToleranceExtension
implements Extension {
    private static final String INTERCEPTOR_PRIORITY_PROPERTY = "mp.fault.tolerance.interceptor.priority";
    private static final Collection<Annotation> ALL_BINDINGS = Arrays.asList(new Asynchronous(){

        @Override
        public Class<? extends Annotation> annotationType() {
            return Asynchronous.class;
        }
    }, new Bulkhead(){

        @Override
        public Class<? extends Annotation> annotationType() {
            return Bulkhead.class;
        }

        @Override
        public int value() {
            return 0;
        }

        @Override
        public int waitingTaskQueue() {
            return 0;
        }
    }, new CircuitBreaker(){

        @Override
        public Class<? extends Annotation> annotationType() {
            return CircuitBreaker.class;
        }

        @Override
        public Class<? extends Throwable>[] failOn() {
            return new Class[0];
        }

        @Override
        public Class<? extends Throwable>[] skipOn() {
            return new Class[0];
        }

        @Override
        public long delay() {
            return 0L;
        }

        @Override
        public ChronoUnit delayUnit() {
            return null;
        }

        @Override
        public int requestVolumeThreshold() {
            return 0;
        }

        @Override
        public double failureRatio() {
            return 0.0;
        }

        @Override
        public int successThreshold() {
            return 0;
        }
    }, new Fallback(){

        @Override
        public Class<? extends Annotation> annotationType() {
            return Fallback.class;
        }

        @Override
        public Class<? extends FallbackHandler<?>> value() {
            return null;
        }

        @Override
        public String fallbackMethod() {
            return null;
        }

        @Override
        public Class<? extends Throwable>[] applyOn() {
            return new Class[0];
        }

        @Override
        public Class<? extends Throwable>[] skipOn() {
            return new Class[0];
        }
    }, new Retry(){

        @Override
        public Class<? extends Annotation> annotationType() {
            return Retry.class;
        }

        @Override
        public int maxRetries() {
            return 0;
        }

        @Override
        public long delay() {
            return 0L;
        }

        @Override
        public ChronoUnit delayUnit() {
            return null;
        }

        @Override
        public long maxDuration() {
            return 0L;
        }

        @Override
        public ChronoUnit durationUnit() {
            return null;
        }

        @Override
        public long jitter() {
            return 0L;
        }

        @Override
        public ChronoUnit jitterDelayUnit() {
            return null;
        }

        @Override
        public Class<? extends Throwable>[] retryOn() {
            return new Class[0];
        }

        @Override
        public Class<? extends Throwable>[] abortOn() {
            return new Class[0];
        }
    }, new Timeout(){

        @Override
        public Class<? extends Annotation> annotationType() {
            return Timeout.class;
        }

        @Override
        public long value() {
            return 0L;
        }

        @Override
        public ChronoUnit unit() {
            return null;
        }
    });

    void beforeBeanDiscovery(@Observes BeforeBeanDiscovery beforeBeanDiscovery, BeanManager beanManager) {
        beforeBeanDiscovery.addAnnotatedType(beanManager.createAnnotatedType(FaultToleranceInterceptor.class), "MP-FT");
    }

    <T> void processAnnotatedType(@Observes @WithAnnotations(value={Asynchronous.class, Bulkhead.class, CircuitBreaker.class, Fallback.class, Retry.class, Timeout.class}) ProcessAnnotatedType<T> processAnnotatedType) throws Exception {
        Class<? extends Annotation>[] alternativeAsynchronousAnnotations = FaultToleranceExtension.getAlternativeAsynchronousAnnotations();
        AnnotatedType type = processAnnotatedType.getAnnotatedType();
        boolean markAllMethods = FaultToleranceUtils.isAnnotatedWithFaultToleranceAnnotations((Annotated)type) || FaultToleranceExtension.isAnyAnnotationPresent((Annotated)type, alternativeAsynchronousAnnotations);
        Class targetClass = type.getJavaClass();
        for (AnnotatedMethodConfigurator methodConfigurator : processAnnotatedType.configureAnnotatedType().methods()) {
            AnnotatedMethod method = methodConfigurator.getAnnotated();
            if (!markAllMethods && !FaultToleranceUtils.isAnnotatedWithFaultToleranceAnnotations((Annotated)method) && !FaultToleranceExtension.isAnyAnnotationPresent((Annotated)method, alternativeAsynchronousAnnotations)) continue;
            FaultTolerancePolicy.asAnnotated(targetClass, method.getJavaMember());
        }
    }

    private static boolean isAnyAnnotationPresent(Annotated element, Class<? extends Annotation>[] annotationTypes) {
        for (Class<? extends Annotation> annotationType : annotationTypes) {
            if (!element.isAnnotationPresent(annotationType)) continue;
            return true;
        }
        return false;
    }

    private static Class<? extends Annotation>[] getAlternativeAsynchronousAnnotations() {
        Optional alternativeAsynchronousAnnotationNames = ConfigProvider.getConfig().getOptionalValue("MP_Fault_Tolerance_Alternative_Asynchronous_Annotations", String.class);
        return alternativeAsynchronousAnnotationNames.isPresent() ? FaultToleranceUtils.toClassArray((String)alternativeAsynchronousAnnotationNames.get(), "MP_Fault_Tolerance_Alternative_Asynchronous_Annotations", FaultToleranceConfig.NO_ALTERNATIVE_ANNOTATIONS) : FaultToleranceConfig.NO_ALTERNATIVE_ANNOTATIONS;
    }

    void enableInterceptor(@Observes AfterTypeDiscovery afterTypeDiscovery) {
        int priority = ConfigProvider.getConfig().getOptionalValue(INTERCEPTOR_PRIORITY_PROPERTY, Integer.class).orElse(4015);
        List interceptors = afterTypeDiscovery.getInterceptors();
        int index = FaultToleranceExtension.determineInterceptorIndex(interceptors, priority);
        if (index != interceptors.size() - 1 || index > interceptors.size() - 1) {
            afterTypeDiscovery.getInterceptors().add(index, FaultToleranceInterceptor.class);
        } else {
            afterTypeDiscovery.getInterceptors().add(FaultToleranceInterceptor.class);
        }
    }

    static int determineInterceptorIndex(List<Class<?>> interceptorsList, int priority) {
        int index = interceptorsList.size() - 1;
        int lowIndex = 0;
        int highIndex = interceptorsList.size() - 1;
        while (lowIndex <= highIndex) {
            int priorityAnnotationValue;
            int midIndex = lowIndex + (highIndex - lowIndex) / 2;
            Priority priorityAnnotation = interceptorsList.get(midIndex).getAnnotation(Priority.class);
            int n = priorityAnnotationValue = priorityAnnotation != null ? priorityAnnotation.value() : 2000;
            if (priorityAnnotationValue < priority) {
                lowIndex = midIndex + 1;
                continue;
            }
            if (priorityAnnotationValue > priority) {
                highIndex = midIndex - 1;
                continue;
            }
            if (priorityAnnotationValue != priority) continue;
            index = midIndex;
            break;
        }
        if (index != interceptorsList.size() - 1) {
            return index;
        }
        if (highIndex != interceptorsList.size() - 1) {
            return lowIndex;
        }
        return interceptorsList.size() - 1;
    }

    void installInterceptor(@Observes AfterBeanDiscovery afterBeanDiscovery, BeanManager beanManager) {
        AnnotatedType at = afterBeanDiscovery.getAnnotatedType(FaultToleranceInterceptor.class, "MP-FT");
        ALL_BINDINGS.forEach(a -> afterBeanDiscovery.addBean((Bean)new ProgrammaticInterceptor((AnnotatedType<FaultToleranceInterceptor>)at, beanManager, (Annotation)a)));
    }

    static class ProgrammaticInterceptor
    implements Interceptor<FaultToleranceInterceptor> {
        private final BeanManager bm;
        private final Annotation binding;
        private final BeanAttributes<FaultToleranceInterceptor> beanAttributes;
        private final InjectionTarget<FaultToleranceInterceptor> injectionTarget;

        ProgrammaticInterceptor(AnnotatedType<FaultToleranceInterceptor> at, BeanManager bm, Annotation binding) {
            this.bm = bm;
            this.binding = binding;
            this.beanAttributes = bm.createBeanAttributes(at);
            this.injectionTarget = bm.createInjectionTarget(at);
        }

        public Set<Annotation> getInterceptorBindings() {
            return Collections.singleton(this.binding);
        }

        public boolean intercepts(InterceptionType type) {
            return type == InterceptionType.AROUND_INVOKE;
        }

        public Object intercept(InterceptionType type, FaultToleranceInterceptor instance, InvocationContext ctx) throws Exception {
            return instance.intercept(ctx);
        }

        public Class<?> getBeanClass() {
            return FaultToleranceInterceptor.class;
        }

        public Set<InjectionPoint> getInjectionPoints() {
            return this.injectionTarget.getInjectionPoints();
        }

        public boolean isNullable() {
            return false;
        }

        public FaultToleranceInterceptor create(CreationalContext<FaultToleranceInterceptor> creationalContext) {
            FaultToleranceInterceptor instance = (FaultToleranceInterceptor)this.injectionTarget.produce(creationalContext);
            this.injectionTarget.inject((Object)instance, creationalContext);
            this.injectionTarget.postConstruct((Object)instance);
            return instance;
        }

        public void destroy(FaultToleranceInterceptor instance, CreationalContext<FaultToleranceInterceptor> creationalContext) {
            try {
                this.injectionTarget.preDestroy((Object)instance);
                this.injectionTarget.dispose((Object)instance);
            }
            finally {
                creationalContext.release();
            }
        }

        public Set<Type> getTypes() {
            return this.beanAttributes.getTypes();
        }

        public Set<Annotation> getQualifiers() {
            return this.beanAttributes.getQualifiers();
        }

        public Class<? extends Annotation> getScope() {
            return this.beanAttributes.getScope();
        }

        public String getName() {
            return this.beanAttributes.getName();
        }

        public Set<Class<? extends Annotation>> getStereotypes() {
            return this.beanAttributes.getStereotypes();
        }

        public boolean isAlternative() {
            return this.beanAttributes.isAlternative();
        }
    }
}

