/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.monitor.stats;

import com.sun.enterprise.admin.monitor.stats.CountStatisticImpl;
import com.sun.enterprise.admin.monitor.stats.MutableCountStatistic;
import com.sun.enterprise.admin.monitor.stats.StatisticImpl;
import javax.management.j2ee.statistics.CountStatistic;
import javax.management.j2ee.statistics.Statistic;

public class MutableCountStatisticImpl
implements CountStatistic,
MutableCountStatistic {
    private final CountStatistic initial;
    private long count;
    private long lastSampleTime;
    private long startTime;

    public MutableCountStatisticImpl(CountStatistic initial) {
        this.initial = initial;
        this.count = initial.getCount();
        this.startTime = this.lastSampleTime = initial.getLastSampleTime();
    }

    @Override
    public void reset() {
        this.count = this.initial.getCount();
        this.startTime = this.lastSampleTime = System.currentTimeMillis();
    }

    @Override
    public void setCount(long count) {
        this.count = count;
        this.lastSampleTime = System.currentTimeMillis();
    }

    @Override
    public Statistic unmodifiableView() {
        return new CountStatisticImpl(this.count, this.initial.getName(), this.initial.getUnit(), this.initial.getDescription(), this.lastSampleTime, this.startTime);
    }

    public long getLastSampleTime() {
        return this.lastSampleTime;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public String getName() {
        return this.initial.getName();
    }

    public String getDescription() {
        return this.initial.getDescription();
    }

    public String getUnit() {
        return this.initial.getUnit();
    }

    @Override
    public Statistic modifiableView() {
        return this;
    }

    public long getCount() {
        return this.count;
    }

    public void setDescription(String s) {
        try {
            ((StatisticImpl)this.initial).setDescription(s);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

