/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.jmx.monitoring;

import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import javax.management.openmbean.CompositeDataSupport;

public class JMXMonitoringJob {
    private final ObjectName mBean;
    private final List<String> attributes;

    public JMXMonitoringJob(ObjectName mBean, List<String> attributes) throws MalformedObjectNameException {
        this.mBean = mBean;
        this.attributes = attributes;
    }

    public String getMonitoringInfo(MBeanServer server) {
        StringBuilder monitoringString = new StringBuilder();
        for (String attribute : this.attributes) {
            String[] attributeToks = attribute.split("\\.");
            try {
                Object responseObj = server.getAttribute(this.mBean, attributeToks[0]);
                String valueString = this.getValueString(attribute, responseObj);
                monitoringString.append(valueString);
            }
            catch (AttributeNotFoundException | InstanceNotFoundException | MBeanException | ReflectionException ex) {
                Logger.getLogger(JMXMonitoringJob.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        return monitoringString.toString();
    }

    public ObjectName getMBean() {
        return this.mBean;
    }

    public List<String> getAttributes() {
        return this.attributes;
    }

    public void addAttribute(String attribute) {
        if (!this.attributes.contains(attribute)) {
            this.attributes.add(attribute);
        }
    }

    private String getValueString(String attributeName, Object attributeObj) {
        StringBuilder attributeString = new StringBuilder();
        if (attributeObj.getClass() == CompositeDataSupport.class) {
            CompositeDataSupport compositeObj = (CompositeDataSupport)attributeObj;
            String[] attributeToks = attributeName.split("\\.");
            switch (attributeToks.length) {
                case 1: {
                    String compositeString = this.getCompositeString(attributeToks[0], compositeObj);
                    attributeString.append(compositeString);
                    break;
                }
                case 2: {
                    String attributeValue = compositeObj.get(attributeToks[1]).toString();
                    attributeString.append(attributeToks[1]);
                    attributeString.append(attributeToks[0]);
                    attributeString.append("=");
                    attributeString.append(attributeValue);
                    attributeString.append(" ");
                    break;
                }
                default: {
                    Logger.getLogger(JMXMonitoringJob.class.getCanonicalName()).log(Level.WARNING, "Could not parse attribute `{0}` it should be of the form `AttributeName` or`AttributeName.property`", attributeName);
                    break;
                }
            }
        } else {
            attributeString.append(attributeName);
            attributeString.append("=");
            attributeString.append(attributeObj.toString());
            attributeString.append(" ");
        }
        return attributeString.toString();
    }

    private String getCompositeString(String attributeName, CompositeDataSupport compositeObj) {
        StringBuilder compositeString = new StringBuilder();
        for (String entry : compositeObj.getCompositeType().keySet()) {
            compositeString.append(entry);
            compositeString.append(attributeName);
            compositeString.append("=");
            compositeString.append(compositeObj.get(entry).toString());
            compositeString.append(" ");
        }
        return compositeString.toString();
    }
}

