/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsclient;

import com.sun.messaging.AdministeredObject;
import com.sun.messaging.jmq.jmsclient.Debug;
import com.sun.messaging.jmq.jmsclient.logging.Loggable;
import com.sun.messaging.jms.JMSException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.jms.JMSRuntimeException;

public class ExceptionHandler {
    private static final String cname = "com.sun.messaging.jmq.jmsclient.ExceptionHandler";
    public static final Logger rootLogger = Logger.getLogger("javax.jms");

    public static void handleConnectException(Exception source, String host, int port) throws javax.jms.JMSException {
        String info = "[" + host + ":" + port + "]";
        ExceptionHandler.throwConnectionException(source, info);
    }

    public static void handleConnectException(Exception source, String url) throws javax.jms.JMSException {
        String info = "[" + url + "]";
        ExceptionHandler.throwConnectionException(source, info);
    }

    private static void throwConnectionException(Exception source, String info) throws javax.jms.JMSException {
        if (source instanceof javax.jms.JMSException && ((javax.jms.JMSException)((Object)source)).getErrorCode() != null) {
            ExceptionHandler.throwJMSException((javax.jms.JMSException)((Object)source));
        }
        String errorString0 = AdministeredObject.cr.getKString("C4003", info);
        String errorString = AdministeredObject.cr.getString("C4038", errorString0, source.toString());
        JMSException jmse = new JMSException(errorString, "C4003");
        if (rootLogger.isLoggable(Level.WARNING) && ExceptionHandler.shouldLog((Exception)((Object)jmse))) {
            rootLogger.log(Level.WARNING, errorString);
        }
        jmse.setLinkedException(source);
        ExceptionHandler.throwJMSException(jmse);
    }

    public static void handleException(Exception source, String errorCode) throws javax.jms.JMSException {
        ExceptionHandler.handleException(source, errorCode, true);
    }

    public static void handleException(Exception source, String errorCode, boolean format) throws javax.jms.JMSException {
        if (source instanceof javax.jms.JMSException && ((javax.jms.JMSException)((Object)source)).getErrorCode() != null) {
            ExceptionHandler.throwJMSException((javax.jms.JMSException)((Object)source));
        }
        ExceptionHandler.handleException(source, ExceptionHandler.getJMSException(source, errorCode, format));
    }

    public static void handleException(Exception source, javax.jms.JMSException target) throws javax.jms.JMSException {
        target.setLinkedException(source);
        if (Debug.debug) {
            ExceptionHandler.printStackTrace(source);
        }
        ExceptionHandler.throwJMSException(target);
    }

    public static void printStackTrace(Exception e) {
        Debug.printStackTrace(e);
    }

    public static javax.jms.JMSException getJMSException(Exception source, String errorCode, boolean format) {
        String errorString = null;
        errorString = source == null ? AdministeredObject.cr.getKString(errorCode) : ExceptionHandler.getExceptionMessage(source, errorCode);
        return new JMSException(errorString, errorCode);
    }

    public static String getExceptionMessage(Exception source, String errorCode) {
        String errorString = null;
        if (errorCode == null) {
            errorCode = "C4038";
        }
        if (errorCode == "C4038") {
            errorString = "[" + "C4038" + "]: " + source.toString();
        } else {
            String errorString0 = AdministeredObject.cr.getKString(errorCode);
            errorString = AdministeredObject.cr.getString("C4038", errorString0, source.toString());
        }
        return errorString;
    }

    public static void throwJMSException(javax.jms.JMSException jmse) throws javax.jms.JMSException {
        ExceptionHandler.throwJMSException(Level.WARNING, jmse);
    }

    public static void throwJMSException(Level level, javax.jms.JMSException jmse) throws javax.jms.JMSException {
        try {
            if (ExceptionHandler.shouldLog((Exception)((Object)jmse))) {
                Exception source = jmse.getLinkedException();
                if (source != null) {
                    ExceptionHandler.logCaughtException(level, source);
                }
                rootLogger.log(Level.FINER, "I501", jmse);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        throw jmse;
    }

    public static void throwJMSRuntimeException(JMSRuntimeException jmsre) {
        ExceptionHandler.throwJMSRuntimeException(Level.WARNING, jmsre);
    }

    public static void throwJMSRuntimeException(Level level, JMSRuntimeException jmsre) {
        try {
            if (ExceptionHandler.shouldLog((Exception)jmsre)) {
                Throwable source = jmsre.getCause();
                if (source != null) {
                    ExceptionHandler.logCaughtException(level, source);
                }
                rootLogger.log(Level.FINER, "I501", (Throwable)jmsre);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        throw jmsre;
    }

    private static boolean shouldLog(Exception e) {
        boolean isLoggable = true;
        if (e instanceof Loggable) {
            if (((Loggable)((Object)e)).getLogState()) {
                isLoggable = false;
            } else {
                ((Loggable)((Object)e)).setLogState(true);
            }
        }
        return isLoggable;
    }

    public static void logCaughtException(Throwable source) {
        ExceptionHandler.logCaughtException(Level.WARNING, source);
    }

    public static void logCaughtException(Level level, Throwable throwable) {
        if (throwable != null && rootLogger.isLoggable(level)) {
            String msg = AdministeredObject.cr.getKString("I500", throwable.toString());
            rootLogger.log(level, msg);
        }
    }

    public static void logError(Throwable thrown) {
        if (thrown != null && rootLogger.isLoggable(Level.SEVERE)) {
            String msg = thrown.toString();
            rootLogger.log(Level.SEVERE, msg, thrown);
        }
    }

    public static void throwRemoteAcknowledgeException(javax.jms.JMSException source, String errorCode) throws javax.jms.JMSException {
        String errorString = AdministeredObject.cr.getKString(errorCode);
        JMSException newjmse = new JMSException(errorString, errorCode);
        if (source != null) {
            newjmse.setLinkedException((Exception)((Object)source));
        }
        ExceptionHandler.throwJMSException(newjmse);
    }
}

