/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.admin.apps.console;

import com.sun.messaging.jmq.admin.apps.console.ActionManager;
import com.sun.messaging.jmq.admin.apps.console.ConsoleHelp;
import com.sun.messaging.jmq.admin.apps.console.ConsoleObj;
import com.sun.messaging.jmq.admin.resources.AdminConsoleResources;
import com.sun.messaging.jmq.admin.util.Globals;
import java.awt.Component;
import java.awt.Toolkit;
import java.awt.event.ActionListener;
import javax.help.HelpBroker;
import javax.help.HelpSet;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JSeparator;
import javax.swing.KeyStroke;

public class AMenuBar
extends JMenuBar {
    private static AdminConsoleResources acr = Globals.getAdminConsoleResources();
    private static final int cmdKey = Toolkit.getDefaultToolkit().getMenuShortcutKeyMask();
    private ActionManager actionMgr = null;
    private ConsoleObj conObj = null;
    private boolean displayIcons;
    private JMenu consoleMenu;
    private JMenuItem showLogItem;
    private JMenuItem showCommandsItem;
    private JMenuItem showHelpItem;
    private JMenuItem prefsItem;
    private JMenuItem exitItem;
    private JMenu editMenu;
    private JMenuItem deleteItem;
    private JMenu actionsMenu;
    private JMenuItem addItem;
    private JMenuItem purgeItem;
    private JMenuItem connectItem;
    private JMenuItem disconnectItem;
    private JMenuItem shutdownBrokerItem;
    private JMenuItem restartBrokerItem;
    private JMenuItem queryBrokerItem;
    private JMenuItem pauseItem;
    private JMenuItem resumeItem;
    private JMenuItem propsItem;
    private JMenu viewMenu;
    private JMenuItem expandItem;
    private JMenuItem collapseItem;
    private JMenuItem refreshItem;
    private JMenu helpMenu;
    private JMenuItem overviewItem;
    private JMenuItem aboutItem;

    public AMenuBar(ActionManager actionMgr) {
        this(actionMgr, true);
    }

    public AMenuBar(ActionManager actionMgr, boolean displayIcons) {
        this.actionMgr = actionMgr;
        this.displayIcons = displayIcons;
        this.initGui();
    }

    public void setConsoleObj(ConsoleObj conObj) {
        this.conObj = conObj;
        this.setLabels();
        this.setIcons();
    }

    private void initGui() {
        this.consoleMenu = this.add(new JMenu(acr.getString("A1000")));
        this.consoleMenu.setMnemonic(acr.getChar("A1039"));
        this.exitItem = this.addMenuItem(this.consoleMenu, 8);
        this.exitItem.setText(acr.getString("A1002"));
        this.exitItem.setMnemonic(acr.getChar("A1041"));
        this.exitItem.setAccelerator(KeyStroke.getKeyStroke((int)acr.getChar("A1224"), cmdKey));
        this.editMenu = this.add(new JMenu(acr.getString("A1003")));
        this.editMenu.setMnemonic(acr.getChar("A1042"));
        this.deleteItem = this.addMenuItem(this.editMenu, 2);
        this.deleteItem.setText(acr.getString("A1018"));
        this.deleteItem.setMnemonic(acr.getChar("A1052"));
        this.actionsMenu = this.add(new JMenu(acr.getString("A1004")));
        this.actionsMenu.setMnemonic(acr.getChar("A1043"));
        this.addItem = this.addMenuItem(this.actionsMenu, 1);
        this.addItem.setText(acr.getString("A1012"));
        this.addItem.setMnemonic(acr.getChar("A1051"));
        this.addItem.setAccelerator(KeyStroke.getKeyStroke((int)acr.getChar("A1225"), cmdKey));
        this.purgeItem = this.addMenuItem(this.actionsMenu, 32768);
        this.purgeItem.setText(acr.getString("A1038"));
        this.purgeItem.setMnemonic(acr.getChar("A1059"));
        this.actionsMenu.add(new JSeparator());
        this.connectItem = this.addMenuItem(this.actionsMenu, 1024);
        this.connectItem.setText(acr.getString("A1024"));
        this.connectItem.setMnemonic(acr.getChar("A1053"));
        this.disconnectItem = this.addMenuItem(this.actionsMenu, 2048);
        this.disconnectItem.setText(acr.getString("A1027"));
        this.disconnectItem.setMnemonic(acr.getChar("A1054"));
        this.actionsMenu.add(new JSeparator());
        this.queryBrokerItem = this.addMenuItem(this.actionsMenu, 65536);
        this.queryBrokerItem.setText(acr.getString("A1505"));
        this.queryBrokerItem.setMnemonic(acr.getChar("A1506"));
        this.pauseItem = this.addMenuItem(this.actionsMenu, 256);
        this.pauseItem.setText(acr.getString("A1030"));
        this.pauseItem.setMnemonic(acr.getChar("A1055"));
        this.resumeItem = this.addMenuItem(this.actionsMenu, 512);
        this.resumeItem.setText(acr.getString("A1033"));
        this.resumeItem.setMnemonic(acr.getChar("A1056"));
        this.restartBrokerItem = this.addMenuItem(this.actionsMenu, 128);
        this.restartBrokerItem.setText(acr.getString("A1037"));
        this.restartBrokerItem.setMnemonic(acr.getChar("A1058"));
        this.shutdownBrokerItem = this.addMenuItem(this.actionsMenu, 64);
        this.shutdownBrokerItem.setText(acr.getString("A1036"));
        this.shutdownBrokerItem.setMnemonic(acr.getChar("A1057"));
        this.actionsMenu.add(new JSeparator());
        this.propsItem = this.addMenuItem(this.actionsMenu, 32);
        this.propsItem.setText(acr.getString("A1005"));
        this.propsItem.setMnemonic(acr.getChar("A1044"));
        this.viewMenu = this.add(new JMenu(acr.getString("A1006")));
        this.viewMenu.setMnemonic(acr.getChar("A1045"));
        this.expandItem = this.addMenuItem(this.viewMenu, 4096);
        this.expandItem.setText(acr.getString("A1007"));
        this.expandItem.setMnemonic(acr.getChar("A1046"));
        this.collapseItem = this.addMenuItem(this.viewMenu, 8192);
        this.collapseItem.setText(acr.getString("A1008"));
        this.collapseItem.setMnemonic(acr.getChar("A1047"));
        this.viewMenu.add(new JSeparator());
        this.refreshItem = this.addMenuItem(this.viewMenu, 16384);
        this.refreshItem.setText(acr.getString("A1009"));
        this.refreshItem.setMnemonic(acr.getChar("A1048"));
        this.add(Box.createGlue());
        this.helpMenu = this.add(new JMenu(acr.getString("A1010")));
        this.helpMenu.setMnemonic(acr.getChar("A1049"));
        this.overviewItem = new JMenuItem(acr.getString("A1154"));
        this.overviewItem.setText(acr.getString("A1106"));
        this.helpMenu.add(this.overviewItem);
        if (ConsoleHelp.helpLoaded()) {
            HelpBroker hb = ConsoleHelp.hb[0];
            HelpSet hs = ConsoleHelp.hs[0];
            this.overviewItem.addActionListener((ActionListener)ConsoleHelp.hl[0]);
            hb.enableHelp((Component)this.overviewItem, "overview", hs);
        } else {
            this.overviewItem.setEnabled(false);
        }
        this.helpMenu.add(new JSeparator());
        this.aboutItem = this.addMenuItem(this.helpMenu, 16);
        this.aboutItem.setText(acr.getString("A1011"));
        this.aboutItem.setMnemonic(acr.getChar("A1050"));
    }

    private JMenuItem addMenuItem(JMenu menu, int actionId) {
        JMenuItem item = menu.add(this.actionMgr.getAction(actionId));
        if (!this.displayIcons) {
            item.setIcon(null);
        }
        return item;
    }

    private void setLabels() {
        if (this.conObj == null) {
            return;
        }
        this.checkAndSetLabel(1, this.addItem);
        this.checkAndSetLabel(1024, this.connectItem);
        this.checkAndSetLabel(2048, this.disconnectItem);
        this.checkAndSetLabel(256, this.pauseItem);
        this.checkAndSetLabel(512, this.resumeItem);
    }

    private void checkAndSetLabel(int actionFlag, JMenuItem item) {
        String label = this.conObj.getActionLabel(actionFlag, true);
        if (label != null) {
            item.setText(label);
        }
    }

    private void setIcons() {
        if (this.conObj == null) {
            return;
        }
        this.checkAndSetIcon(1024, this.connectItem);
        this.checkAndSetIcon(2048, this.disconnectItem);
    }

    private void checkAndSetIcon(int actionFlag, JMenuItem item) {
        ImageIcon icon = this.conObj.getActionIcon(actionFlag);
        if (icon != null) {
            item.setIcon(icon);
        }
    }
}

