/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.ejb.deployment.node.runtime;

import com.sun.enterprise.deployment.EjbIORConfigurationDescriptor;
import com.sun.enterprise.deployment.RunAsIdentityDescriptor;
import com.sun.enterprise.deployment.node.DeploymentDescriptorNode;
import com.sun.enterprise.deployment.node.XMLElement;
import com.sun.enterprise.deployment.node.runtime.EjbRefNode;
import com.sun.enterprise.deployment.node.runtime.MessageDestinationRefNode;
import com.sun.enterprise.deployment.node.runtime.ResourceEnvRefNode;
import com.sun.enterprise.deployment.node.runtime.ResourceRefNode;
import com.sun.enterprise.deployment.node.runtime.RuntimeDescriptorNode;
import com.sun.enterprise.deployment.node.runtime.ServiceRefNode;
import com.sun.enterprise.deployment.node.runtime.WebServiceEndpointRuntimeNode;
import com.sun.enterprise.deployment.runtime.BeanPoolDescriptor;
import com.sun.enterprise.deployment.util.DOLUtils;
import fish.payara.cluster.DistributedLockType;
import java.util.Map;
import java.util.logging.Level;
import org.glassfish.deployment.common.Descriptor;
import org.glassfish.ejb.deployment.descriptor.EjbBundleDescriptorImpl;
import org.glassfish.ejb.deployment.descriptor.EjbDescriptor;
import org.glassfish.ejb.deployment.descriptor.EjbMessageBeanDescriptor;
import org.glassfish.ejb.deployment.descriptor.EjbSessionDescriptor;
import org.glassfish.ejb.deployment.descriptor.IASEjbCMPEntityDescriptor;
import org.glassfish.ejb.deployment.descriptor.runtime.BeanCacheDescriptor;
import org.glassfish.ejb.deployment.descriptor.runtime.CheckpointAtEndOfMethodDescriptor;
import org.glassfish.ejb.deployment.descriptor.runtime.FlushAtEndOfMethodDescriptor;
import org.glassfish.ejb.deployment.descriptor.runtime.MdbConnectionFactoryDescriptor;
import org.glassfish.ejb.deployment.node.runtime.BeanCacheNode;
import org.glassfish.ejb.deployment.node.runtime.BeanPoolNode;
import org.glassfish.ejb.deployment.node.runtime.CheckpointAtEndOfMethodNode;
import org.glassfish.ejb.deployment.node.runtime.CmpNode;
import org.glassfish.ejb.deployment.node.runtime.FlushAtEndOfMethodNode;
import org.glassfish.ejb.deployment.node.runtime.IORConfigurationNode;
import org.glassfish.ejb.deployment.node.runtime.MDBConnectionFactoryNode;
import org.glassfish.ejb.deployment.node.runtime.MDBResourceAdapterNode;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class EjbNode
extends DeploymentDescriptorNode<EjbDescriptor> {
    private EjbDescriptor descriptor;
    private String availEnabled;

    public EjbNode() {
        this.registerElementHandler(new XMLElement("resource-ref"), ResourceRefNode.class);
        this.registerElementHandler(new XMLElement("ejb-ref"), EjbRefNode.class);
        this.registerElementHandler(new XMLElement("resource-env-ref"), ResourceEnvRefNode.class);
        this.registerElementHandler(new XMLElement("message-destination-ref"), MessageDestinationRefNode.class);
        this.registerElementHandler(new XMLElement("service-ref"), ServiceRefNode.class);
        this.registerElementHandler(new XMLElement("cmp"), CmpNode.class);
        this.registerElementHandler(new XMLElement("mdb-connection-factory"), MDBConnectionFactoryNode.class);
        this.registerElementHandler(new XMLElement("ior-security-config"), IORConfigurationNode.class, "addIORConfigurationDescriptor");
        this.registerElementHandler(new XMLElement("bean-pool"), BeanPoolNode.class);
        this.registerElementHandler(new XMLElement("bean-cache"), BeanCacheNode.class);
        this.registerElementHandler(new XMLElement("mdb-resource-adapter"), MDBResourceAdapterNode.class);
        this.registerElementHandler(new XMLElement("webservice-endpoint"), WebServiceEndpointRuntimeNode.class);
        this.registerElementHandler(new XMLElement("flush-at-end-of-method"), FlushAtEndOfMethodNode.class);
        this.registerElementHandler(new XMLElement("checkpoint-at-end-of-method"), CheckpointAtEndOfMethodNode.class);
    }

    public EjbDescriptor getDescriptor() {
        return this.descriptor;
    }

    public void setElementValue(XMLElement element, String value) {
        String qName = element.getQName();
        boolean isAvailabilityEnabled = "availability-enabled".equals(qName);
        if ("ejb-name".equals(qName)) {
            Object parentDesc = this.getParentNode().getDescriptor();
            if (parentDesc != null && parentDesc instanceof EjbBundleDescriptorImpl) {
                this.descriptor = ((EjbBundleDescriptorImpl)((Object)parentDesc)).getEjbByName(value);
            }
            if (this.descriptor == null) {
                DOLUtils.getDefaultLogger().log(Level.SEVERE, "enterprise.deployment.backend.addDescriptorFailure", new Object[]{element, value});
            } else if (this.availEnabled != null) {
                this.descriptor.getIASEjbExtraDescriptors().setAttributeValue("AvailabilityEnabled", this.availEnabled);
            }
            return;
        }
        if (this.descriptor == null && !isAvailabilityEnabled) {
            DOLUtils.getDefaultLogger().log(Level.SEVERE, "enterprise.deployment.backend.addDescriptorFailure", new Object[]{qName, value});
            super.setElementValue(element, value);
            return;
        }
        if (isAvailabilityEnabled) {
            this.availEnabled = value;
        } else if ("name".equals(qName)) {
            if (Boolean.FALSE.equals(this.descriptor.getUsesCallerIdentity()) && this.descriptor.getRunAsIdentity() != null) {
                this.descriptor.getRunAsIdentity().setPrincipal(value);
            }
        } else if ("pass-by-reference".equals(qName)) {
            this.descriptor.getIASEjbExtraDescriptors().setPassByReference(Boolean.valueOf(value));
        } else if ("jms-max-messages-load".equals(qName)) {
            this.descriptor.getIASEjbExtraDescriptors().setJmsMaxMessagesLoad(Integer.parseInt(value));
        } else if ("is-read-only-bean".equals(qName)) {
            this.descriptor.getIASEjbExtraDescriptors().setIsReadOnlyBean(Boolean.valueOf(value));
        } else if ("refresh-period-in-seconds".equals(qName)) {
            this.descriptor.getIASEjbExtraDescriptors().setRefreshPeriodInSeconds(Integer.parseInt(value));
        } else if ("commit-option".equals(qName)) {
            this.descriptor.getIASEjbExtraDescriptors().setCommitOption(value);
        } else if ("cmt-timeout-in-seconds".equals(qName)) {
            this.descriptor.getIASEjbExtraDescriptors().setCmtTimeoutInSeconds(Integer.parseInt(value));
        } else if ("use-thread-pool-id".equals(qName)) {
            this.descriptor.getIASEjbExtraDescriptors().setUseThreadPoolId(value);
        } else if ("checkpointed-methods".equals(qName)) {
            this.descriptor.getIASEjbExtraDescriptors().setCheckpointedMethods(value);
        } else if ("per-request-load-balancing".equals(qName)) {
            this.descriptor.getIASEjbExtraDescriptors().setPerRequestLoadBalancing(Boolean.valueOf(value));
        } else if ("clustered-bean".equals(qName)) {
            ((EjbSessionDescriptor)this.descriptor).setClustered(Boolean.valueOf(value));
        } else if ("clustered-key-name".equals(qName)) {
            ((EjbSessionDescriptor)this.descriptor).setClusteredKeyValue(value);
        } else if ("clustered-lock-type".equals(qName)) {
            EjbSessionDescriptor ejbDesc = (EjbSessionDescriptor)this.descriptor;
            switch (value.toLowerCase()) {
                case "inherit": {
                    ejbDesc.setClusteredLockType(DistributedLockType.INHERIT);
                    break;
                }
                case "none": {
                    ejbDesc.setClusteredLockType(DistributedLockType.LOCK_NONE);
                    break;
                }
                default: {
                    DOLUtils.getDefaultLogger().log(Level.WARNING, "Invalid clustered lock type: {0}", value);
                    break;
                }
            }
        } else if ("clustered-attach-postconstruct".equals(qName)) {
            ((EjbSessionDescriptor)this.descriptor).setDontCallPostConstructOnAttach(Boolean.valueOf(value) == false);
        } else if ("clustered-detach-predestroy".equals(qName)) {
            ((EjbSessionDescriptor)this.descriptor).setDontCallPreDestroyOnDetach(Boolean.valueOf(value) == false);
        } else {
            super.setElementValue(element, value);
        }
    }

    protected Map<String, String> getDispatchTable() {
        Map table = super.getDispatchTable();
        table.put("jndi-name", "setJndiName");
        table.put("remote-impl", "setEJBObjectImplClassName");
        table.put("local-impl", "setEJBLocalObjectImplClassName");
        table.put("remote-home-impl", "setRemoteHomeImplClassName");
        table.put("local-home-impl", "setLocalHomeImplClassName");
        table.put("jms-durable-subscription-name", "setDurableSubscriptionName");
        table.put("mdb-connection-factory", "setConnectionFactoryName");
        table.put("resource-adapter-mid", "setResourceAdapterMid");
        return table;
    }

    public boolean endElement(XMLElement element) {
        if ("ejb".equals(element.getQName())) {
            this.descriptor.getIASEjbExtraDescriptors().parseCheckpointedMethods(this.descriptor);
        }
        return super.endElement(element);
    }

    public void addDescriptor(Object newDescriptor) {
        if (newDescriptor instanceof MdbConnectionFactoryDescriptor) {
            this.descriptor.getIASEjbExtraDescriptors().setMdbConnectionFactory((MdbConnectionFactoryDescriptor)((Object)newDescriptor));
        } else if (newDescriptor instanceof BeanPoolDescriptor) {
            this.descriptor.getIASEjbExtraDescriptors().setBeanPool((BeanPoolDescriptor)newDescriptor);
        } else if (newDescriptor instanceof BeanCacheDescriptor) {
            this.descriptor.getIASEjbExtraDescriptors().setBeanCache((BeanCacheDescriptor)((Object)newDescriptor));
        } else if (newDescriptor instanceof FlushAtEndOfMethodDescriptor) {
            this.descriptor.getIASEjbExtraDescriptors().setFlushAtEndOfMethodDescriptor((FlushAtEndOfMethodDescriptor)((Object)newDescriptor));
        } else if (newDescriptor instanceof CheckpointAtEndOfMethodDescriptor) {
            this.descriptor.getIASEjbExtraDescriptors().setCheckpointAtEndOfMethodDescriptor((CheckpointAtEndOfMethodDescriptor)((Object)newDescriptor));
        }
    }

    public Node writeDescriptor(Node parent, String nodeName, EjbDescriptor ejbDescriptor) {
        CheckpointAtEndOfMethodDescriptor checkpointMethodDesc;
        BeanCacheDescriptor beanCacheDesc;
        RunAsIdentityDescriptor raid;
        Element ejbNode = (Element)super.writeDescriptor(parent, nodeName, (Object)ejbDescriptor);
        EjbNode.appendTextChild((Node)ejbNode, (String)"ejb-name", (String)ejbDescriptor.getName());
        EjbNode.appendTextChild((Node)ejbNode, (String)"jndi-name", (String)ejbDescriptor.getJndiName());
        RuntimeDescriptorNode.writeCommonComponentInfo((Node)ejbNode, (Descriptor)ejbDescriptor);
        EjbNode.appendTextChild((Node)ejbNode, (String)"pass-by-reference", (String)String.valueOf(ejbDescriptor.getIASEjbExtraDescriptors().getPassByReference()));
        if (ejbDescriptor instanceof IASEjbCMPEntityDescriptor) {
            CmpNode cmpNode = new CmpNode();
            cmpNode.writeDescriptor((Node)ejbNode, "cmp", (IASEjbCMPEntityDescriptor)ejbDescriptor);
        }
        if (Boolean.FALSE.equals(ejbDescriptor.getUsesCallerIdentity()) && (raid = ejbDescriptor.getRunAsIdentity()) != null && raid.getPrincipal() != null) {
            Element principalNode = EjbNode.appendChild((Node)ejbNode, (String)"principal");
            EjbNode.appendTextChild((Node)principalNode, (String)"name", (String)raid.getPrincipal());
        }
        if (ejbDescriptor instanceof EjbMessageBeanDescriptor) {
            EjbMessageBeanDescriptor msgBeanDesc = (EjbMessageBeanDescriptor)ejbDescriptor;
            if (ejbDescriptor.getIASEjbExtraDescriptors().getMdbConnectionFactory() != null) {
                MDBConnectionFactoryNode mcfNode = new MDBConnectionFactoryNode();
                mcfNode.writeDescriptor((Node)ejbNode, "mdb-connection-factory", ejbDescriptor.getIASEjbExtraDescriptors().getMdbConnectionFactory());
            }
            if (msgBeanDesc.hasDurableSubscription()) {
                EjbNode.appendTextChild((Node)ejbNode, (String)"jms-durable-subscription-name", (String)msgBeanDesc.getDurableSubscriptionName());
            }
            EjbNode.appendTextChild((Node)ejbNode, (String)"jms-max-messages-load", (String)String.valueOf(ejbDescriptor.getIASEjbExtraDescriptors().getJmsMaxMessagesLoad()));
        }
        IORConfigurationNode iorNode = new IORConfigurationNode();
        for (EjbIORConfigurationDescriptor iorConf : ejbDescriptor.getIORConfigurationDescriptors()) {
            iorNode.writeDescriptor((Node)ejbNode, "ior-security-config", iorConf);
        }
        EjbNode.appendTextChild((Node)ejbNode, (String)"is-read-only-bean", (String)String.valueOf(ejbDescriptor.getIASEjbExtraDescriptors().isIsReadOnlyBean()));
        EjbNode.appendTextChild((Node)ejbNode, (String)"refresh-period-in-seconds", (String)String.valueOf(ejbDescriptor.getIASEjbExtraDescriptors().getRefreshPeriodInSeconds()));
        EjbNode.appendTextChild((Node)ejbNode, (String)"commit-option", (String)ejbDescriptor.getIASEjbExtraDescriptors().getCommitOption());
        EjbNode.appendTextChild((Node)ejbNode, (String)"cmt-timeout-in-seconds", (String)String.valueOf(ejbDescriptor.getIASEjbExtraDescriptors().getCmtTimeoutInSeconds()));
        EjbNode.appendTextChild((Node)ejbNode, (String)"use-thread-pool-id", (String)ejbDescriptor.getIASEjbExtraDescriptors().getUseThreadPoolId());
        EjbNode.writeGenClasses(ejbNode, ejbDescriptor);
        BeanPoolDescriptor beanPoolDesc = ejbDescriptor.getIASEjbExtraDescriptors().getBeanPool();
        if (beanPoolDesc != null) {
            BeanPoolNode bpNode = new BeanPoolNode();
            bpNode.writeDescriptor((Node)ejbNode, "bean-pool", beanPoolDesc);
        }
        if ((beanCacheDesc = ejbDescriptor.getIASEjbExtraDescriptors().getBeanCache()) != null) {
            BeanCacheNode bcNode = new BeanCacheNode();
            bcNode.writeDescriptor((Node)ejbNode, "bean-cache", beanCacheDesc);
        }
        if (ejbDescriptor instanceof EjbMessageBeanDescriptor) {
            EjbMessageBeanDescriptor msgBeanDesc = (EjbMessageBeanDescriptor)ejbDescriptor;
            if (msgBeanDesc.hasResourceAdapterMid()) {
                MDBResourceAdapterNode mdb = new MDBResourceAdapterNode();
                mdb.writeDescriptor(ejbNode, "mdb-resource-adapter", msgBeanDesc);
            }
        } else if (ejbDescriptor instanceof com.sun.enterprise.deployment.EjbSessionDescriptor) {
            WebServiceEndpointRuntimeNode wsRuntime = new WebServiceEndpointRuntimeNode();
            wsRuntime.writeWebServiceEndpointInfo((Node)ejbNode, (com.sun.enterprise.deployment.EjbDescriptor)ejbDescriptor);
        }
        FlushAtEndOfMethodDescriptor flushMethodDesc = ejbDescriptor.getIASEjbExtraDescriptors().getFlushAtEndOfMethodDescriptor();
        if (flushMethodDesc != null) {
            FlushAtEndOfMethodNode flushNode = new FlushAtEndOfMethodNode();
            flushNode.writeDescriptor((Node)ejbNode, "flush-at-end-of-method", flushMethodDesc);
        }
        if ((checkpointMethodDesc = ejbDescriptor.getIASEjbExtraDescriptors().getCheckpointAtEndOfMethodDescriptor()) != null) {
            CheckpointAtEndOfMethodNode checkpointNode = new CheckpointAtEndOfMethodNode();
            checkpointNode.writeDescriptor((Node)ejbNode, "checkpoint-at-end-of-method", checkpointMethodDesc);
        }
        if (ejbDescriptor.getIASEjbExtraDescriptors().getPerRequestLoadBalancing() != null) {
            EjbNode.appendTextChild((Node)ejbNode, (String)"per-request-load-balancing", (String)String.valueOf(ejbDescriptor.getIASEjbExtraDescriptors().getPerRequestLoadBalancing()));
        }
        EjbNode.setAttribute((Element)ejbNode, (String)"availability-enabled", (String)ejbDescriptor.getIASEjbExtraDescriptors().getAttributeValue("AvailabilityEnabled"));
        return ejbNode;
    }

    private static void writeGenClasses(Node parent, EjbDescriptor ejbDescriptor) {
        Element genClasses = EjbNode.appendChild((Node)parent, (String)"gen-classes");
        EjbNode.appendTextChild((Node)genClasses, (String)"remote-impl", (String)ejbDescriptor.getEJBObjectImplClassName());
        EjbNode.appendTextChild((Node)genClasses, (String)"local-impl", (String)ejbDescriptor.getEJBLocalObjectImplClassName());
        EjbNode.appendTextChild((Node)genClasses, (String)"remote-home-impl", (String)ejbDescriptor.getRemoteHomeImplClassName());
        EjbNode.appendTextChild((Node)genClasses, (String)"local-home-impl", (String)ejbDescriptor.getLocalHomeImplClassName());
    }
}

