/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.ejb.deployment.node.runtime;

import com.sun.enterprise.deployment.EjbBundleDescriptor;
import com.sun.enterprise.deployment.WebService;
import com.sun.enterprise.deployment.WebServiceEndpoint;
import com.sun.enterprise.deployment.node.XMLElement;
import com.sun.enterprise.deployment.node.runtime.RuntimeDescriptorNode;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class DefaultWebServiceLoginConfigNode
extends RuntimeDescriptorNode {
    private String realm;
    private String authMethod;
    private static final Logger log = Logger.getLogger(DefaultWebServiceLoginConfigNode.class.getName());

    protected Map getDispatchTable() {
        Map table = super.getDispatchTable();
        table.put("auth-method", "setAuthMethod");
        table.put("realm", "setRealm");
        return table;
    }

    public Object getDescriptor() {
        return this;
    }

    public boolean endElement(XMLElement element) {
        log.log(Level.FINEST, "End Element: {0}", element.getQName());
        if (this.authMethod != null && element.getQName().equals("webservice-default-login-config")) {
            EjbBundleDescriptor descriptor = (EjbBundleDescriptor)this.getParentNode().getDescriptor();
            for (WebService wsDesc : descriptor.getWebServices().getWebServices()) {
                for (WebServiceEndpoint endpoint : wsDesc.getEndpoints()) {
                    if (endpoint.hasAuthMethod()) continue;
                    log.log(Level.FINE, "Default Login for Web Service Endpoint: {0}, Method {1}, Realm {2}", new Object[]{endpoint.getName(), this.authMethod, this.realm});
                    endpoint.setAuthMethod(this.authMethod);
                    endpoint.setRealm(this.realm);
                }
            }
        }
        return super.endElement(element);
    }

    public void setRealm(String realm) {
        log.log(Level.FINEST, "Global Setting Realm: {0}", realm);
        this.realm = realm;
    }

    public void setAuthMethod(String authMethod) {
        log.log(Level.FINEST, "Global Setting Auth Method: {0}", authMethod);
        this.authMethod = authMethod;
    }
}

