/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.jdbc;

import fish.payara.jdbc.SQLQuery;
import java.lang.annotation.Annotation;
import org.glassfish.api.jdbc.SQLTraceListener;
import org.glassfish.api.jdbc.SQLTraceRecord;
import org.glassfish.api.jdbc.SQLTraceStore;
import org.glassfish.internal.api.Globals;

public class SQLTraceStoreAdapter
implements SQLTraceListener {
    private static ThreadLocal<SQLQuery> currentQuery = new ThreadLocal();
    private final SQLTraceStore store = (SQLTraceStore)Globals.getDefaultHabitat().getService(SQLTraceStore.class, new Annotation[0]);

    public void sqlTrace(SQLTraceRecord record) {
        if (record != null) {
            switch (record.getMethodName()) {
                case "nativeSQL": 
                case "prepareCall": 
                case "prepareStatement": 
                case "addBatch": {
                    SQLTraceStoreAdapter.aquireSQL(record);
                    break;
                }
                case "execute": 
                case "executeQuery": 
                case "executeUpdate": {
                    this.trace(record);
                    break;
                }
            }
        }
    }

    private void trace(SQLTraceRecord record) {
        SQLQuery query = SQLTraceStoreAdapter.aquireSQL(record);
        if (this.store != null) {
            this.store.trace(record, query.getSQL());
        }
        currentQuery.set(null);
    }

    private static SQLQuery aquireSQL(SQLTraceRecord record) {
        SQLQuery query = currentQuery.get();
        if (query == null) {
            query = new SQLQuery();
            currentQuery.set(query);
        }
        if (record.getParams() != null && record.getParams().length > 0) {
            query.addSQL((String)record.getParams()[0]);
        }
        return query;
    }
}

