/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.microprofile.jwtauth.eesecurity;

import fish.payara.microprofile.jwtauth.eesecurity.JwtPublicKeyStore;
import fish.payara.microprofile.jwtauth.eesecurity.SignedJWTCredential;
import fish.payara.microprofile.jwtauth.jwt.JsonWebTokenImpl;
import fish.payara.microprofile.jwtauth.jwt.JwtTokenParser;
import java.io.IOException;
import java.net.URL;
import java.security.PublicKey;
import java.time.Duration;
import java.util.Collection;
import java.util.HashSet;
import java.util.Optional;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.security.enterprise.CallerPrincipal;
import javax.security.enterprise.identitystore.CredentialValidationResult;
import javax.security.enterprise.identitystore.IdentityStore;
import org.eclipse.microprofile.config.Config;
import org.eclipse.microprofile.config.ConfigProvider;

public class SignedJWTIdentityStore
implements IdentityStore {
    private static final Logger LOGGER = Logger.getLogger(SignedJWTIdentityStore.class.getName());
    private final String acceptedIssuer;
    private final Optional<Boolean> enabledNamespace;
    private final Optional<String> customNamespace;
    private final Optional<Boolean> disableTypeVerification;
    private final Config config = ConfigProvider.getConfig();
    private final JwtPublicKeyStore publicKeyStore;

    public SignedJWTIdentityStore() {
        Optional<Properties> properties = this.readVendorProperties();
        this.acceptedIssuer = this.readVendorIssuer(properties).orElseGet(() -> (String)this.config.getOptionalValue("mp.jwt.verify.issuer", String.class).orElseThrow(() -> new IllegalStateException("No issuer found")));
        this.enabledNamespace = this.readEnabledNamespace(properties);
        this.customNamespace = this.readCustomNamespace(properties);
        this.disableTypeVerification = this.readDisableTypeVerification(properties);
        this.publicKeyStore = new JwtPublicKeyStore(this.readPublicKeyCacheTTL(properties));
    }

    public CredentialValidationResult validate(SignedJWTCredential signedJWTCredential) {
        JwtTokenParser jwtTokenParser = new JwtTokenParser(this.enabledNamespace, this.customNamespace, this.disableTypeVerification);
        try {
            jwtTokenParser.parse(signedJWTCredential.getSignedJWT());
            String keyID = jwtTokenParser.getKeyID();
            PublicKey publicKey = this.publicKeyStore.getPublicKey(keyID);
            JsonWebTokenImpl jsonWebToken = jwtTokenParser.verify(this.acceptedIssuer, publicKey);
            HashSet groups = new HashSet();
            Collection groupClaims = (Collection)jsonWebToken.getClaim("groups");
            if (groupClaims != null) {
                groups.addAll(groupClaims);
            }
            return new CredentialValidationResult((CallerPrincipal)jsonWebToken, groups);
        }
        catch (Exception e) {
            LOGGER.log(Level.INFO, "Exception trying to parse JWT token.", e);
            return CredentialValidationResult.INVALID_RESULT;
        }
    }

    private Optional<Properties> readVendorProperties() {
        URL mpJwtResource = Thread.currentThread().getContextClassLoader().getResource("/payara-mp-jwt.properties");
        Properties properties = null;
        if (mpJwtResource != null) {
            try {
                properties = new Properties();
                properties.load(mpJwtResource.openStream());
            }
            catch (IOException e) {
                throw new IllegalStateException("Failed to load Vendor properties from resource file", e);
            }
        }
        return Optional.ofNullable(properties);
    }

    private Optional<String> readVendorIssuer(Optional<Properties> properties) {
        return properties.isPresent() ? Optional.ofNullable(properties.get().getProperty("accepted.issuer")) : Optional.empty();
    }

    private Optional<Boolean> readEnabledNamespace(Optional<Properties> properties) {
        return properties.isPresent() ? Optional.ofNullable(Boolean.valueOf(properties.get().getProperty("enable.namespace", "false"))) : Optional.empty();
    }

    private Optional<String> readCustomNamespace(Optional<Properties> properties) {
        return properties.isPresent() ? Optional.ofNullable(properties.get().getProperty("custom.namespace", null)) : Optional.empty();
    }

    private Optional<Boolean> readDisableTypeVerification(Optional<Properties> properties) {
        return properties.isPresent() ? Optional.ofNullable(Boolean.valueOf(properties.get().getProperty("disable.type.verification", "false"))) : Optional.empty();
    }

    private Duration readPublicKeyCacheTTL(Optional<Properties> properties) {
        return properties.map(props -> props.getProperty("publicKey.cache.ttl")).map(Long::valueOf).map(Duration::ofMillis).orElseGet(() -> Duration.ofMinutes(5L));
    }
}

