/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.microprofile.jwtauth.eesecurity;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.math.BigInteger;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.KeyFactory;
import java.security.PublicKey;
import java.security.spec.RSAPublicKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.time.Duration;
import java.util.Base64;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.logging.Logger;
import java.util.stream.Stream;
import javax.enterprise.inject.spi.DeploymentException;
import javax.json.Json;
import javax.json.JsonArray;
import javax.json.JsonObject;
import javax.json.JsonReader;
import javax.json.JsonValue;
import org.eclipse.microprofile.config.Config;
import org.eclipse.microprofile.config.ConfigProvider;

class JwtPublicKeyStore {
    private static final Logger LOGGER = Logger.getLogger(JwtPublicKeyStore.class.getName());
    private static final String RSA_ALGORITHM = "RSA";
    private final Config config = ConfigProvider.getConfig();
    private final Supplier<Optional<String>> cacheSupplier;
    private final Duration defaultCacheTTL;

    public JwtPublicKeyStore(Duration defaultCacheTTL) {
        this.defaultCacheTTL = defaultCacheTTL;
        this.cacheSupplier = new PublicKeyLoadingCache(this::readRawPublicKey)::get;
    }

    public PublicKey getPublicKey(String keyID) {
        return this.cacheSupplier.get().map(key -> this.createPublicKey((String)key, keyID)).orElseThrow(() -> new IllegalStateException("No PublicKey found"));
    }

    private CacheableString readRawPublicKey() {
        CacheableString publicKey = this.readDefaultPublicKey();
        if (!publicKey.isPresent()) {
            publicKey = this.readMPEmbeddedPublicKey();
        }
        if (!publicKey.isPresent()) {
            publicKey = this.readMPPublicKeyFromLocation();
        }
        return publicKey;
    }

    private CacheableString readDefaultPublicKey() {
        return this.readPublicKeyFromLocation("/publicKey.pem");
    }

    private CacheableString readMPEmbeddedPublicKey() {
        String publicKey = this.config.getOptionalValue("mp.jwt.verify.publickey", String.class).orElse(null);
        return CacheableString.from(publicKey, this.defaultCacheTTL);
    }

    private CacheableString readMPPublicKeyFromLocation() {
        Optional locationOpt = this.config.getOptionalValue("mp.jwt.verify.publickey.location", String.class);
        if (!locationOpt.isPresent()) {
            return CacheableString.empty(this.defaultCacheTTL);
        }
        String publicKeyLocation = (String)locationOpt.get();
        return this.readPublicKeyFromLocation(publicKeyLocation);
    }

    private CacheableString readPublicKeyFromLocation(String publicKeyLocation) {
        URL publicKeyURL = Thread.currentThread().getContextClassLoader().getResource(publicKeyLocation);
        if (publicKeyURL == null) {
            try {
                publicKeyURL = new URL(publicKeyLocation);
            }
            catch (MalformedURLException ex) {
                publicKeyURL = null;
            }
        }
        if (publicKeyURL == null) {
            return CacheableString.empty(this.defaultCacheTTL);
        }
        try {
            return this.readPublicKeyFromURL(publicKeyURL);
        }
        catch (IOException ex) {
            throw new IllegalStateException("Failed to read public key.", ex);
        }
    }

    /*
     * Exception decompiling
     */
    private CacheableString readPublicKeyFromURL(URL publicKeyURL) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private PublicKey createPublicKey(String key, String keyID) {
        try {
            return this.createPublicKeyFromPem(key);
        }
        catch (Exception pemEx) {
            try {
                return this.createPublicKeyFromJWKS(key, keyID);
            }
            catch (Exception jwksEx) {
                throw new DeploymentException((Throwable)jwksEx);
            }
        }
    }

    private PublicKey createPublicKeyFromPem(String key) throws Exception {
        key = key.replaceAll("-----BEGIN (.*)-----", "").replaceAll("-----END (.*)----", "").replaceAll("\r\n", "").replaceAll("\n", "").trim();
        byte[] keyBytes = Base64.getDecoder().decode(key);
        X509EncodedKeySpec publicKeySpec = new X509EncodedKeySpec(keyBytes);
        return KeyFactory.getInstance(RSA_ALGORITHM).generatePublic(publicKeySpec);
    }

    private PublicKey createPublicKeyFromJWKS(String jwksValue, String keyID) throws Exception {
        JsonObject jwks = this.parseJwks(jwksValue);
        JsonArray keys = jwks.getJsonArray("keys");
        JsonObject jwk = keys != null ? this.findJwk(keys, keyID) : jwks;
        byte[] exponentBytes = Base64.getUrlDecoder().decode(jwk.getString("e"));
        BigInteger exponent = new BigInteger(1, exponentBytes);
        byte[] modulusBytes = Base64.getUrlDecoder().decode(jwk.getString("n"));
        BigInteger modulus = new BigInteger(1, modulusBytes);
        RSAPublicKeySpec publicKeySpec = new RSAPublicKeySpec(modulus, exponent);
        return KeyFactory.getInstance(RSA_ALGORITHM).generatePublic(publicKeySpec);
    }

    private JsonObject parseJwks(String jwksValue) throws Exception {
        JsonObject jwks;
        try (JsonReader reader = Json.createReader((Reader)new StringReader(jwksValue));){
            jwks = reader.readObject();
        }
        catch (Exception ex) {
            byte[] jwksDecodedValue = Base64.getDecoder().decode(jwksValue);
            try (ByteArrayInputStream jwksStream = new ByteArrayInputStream(jwksDecodedValue);
                 JsonReader reader2 = Json.createReader((InputStream)jwksStream);){
                jwks = reader2.readObject();
            }
        }
        return jwks;
    }

    private JsonObject findJwk(JsonArray keys, String keyID) {
        if (Objects.isNull(keyID) && keys.size() > 0) {
            return keys.getJsonObject(0);
        }
        for (JsonValue value : keys) {
            JsonObject jwk = value.asJsonObject();
            if (!Objects.equals(keyID, jwk.getString("kid"))) continue;
            return jwk;
        }
        throw new IllegalStateException("No matching JWK for KeyID.");
    }

    private static /* synthetic */ Duration lambda$readPublicKeyFromURL$6(String maxAgeDirective) {
        String[] keyValue = maxAgeDirective.split("=", 2);
        String maxAge = keyValue[keyValue.length - 1];
        try {
            return Duration.ofSeconds(Long.parseLong(maxAge));
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    private static /* synthetic */ boolean lambda$readPublicKeyFromURL$5(String directive) {
        return directive.trim().startsWith("max-age");
    }

    private static /* synthetic */ Stream lambda$readPublicKeyFromURL$4(String headerValue) {
        return Stream.of(headerValue.split(","));
    }

    private static /* synthetic */ Stream lambda$readPublicKeyFromURL$3(Map.Entry headers) {
        return ((List)headers.getValue()).stream();
    }

    private static /* synthetic */ boolean lambda$readPublicKeyFromURL$2(Map.Entry e) {
        return e.getKey() != null && ((String)e.getKey()).trim().equalsIgnoreCase("Cache-Control");
    }

    private static class CacheableString {
        private String value;
        private Duration cacheTTL;

        private CacheableString() {
        }

        public static CacheableString empty(Duration cacheTTL) {
            return CacheableString.from(null, cacheTTL);
        }

        public static CacheableString from(String value, Duration cacheTTL) {
            CacheableString instance = new CacheableString();
            instance.cacheTTL = cacheTTL;
            instance.value = value;
            return instance;
        }

        public Optional<String> getValue() {
            return Optional.ofNullable(this.value);
        }

        public Duration getCacheTTL() {
            return this.cacheTTL;
        }

        public boolean isPresent() {
            return this.value != null;
        }
    }

    private static class PublicKeyLoadingCache {
        private final Supplier<CacheableString> keySupplier;
        private Duration ttl = Duration.ZERO;
        private long lastUpdated;
        private Optional<String> publicKey;

        public PublicKeyLoadingCache(Supplier<CacheableString> keySupplier) {
            this.keySupplier = keySupplier;
        }

        public Optional<String> get() {
            long now = System.currentTimeMillis();
            if (now - this.lastUpdated > this.ttl.toMillis()) {
                this.refresh();
            }
            return this.publicKey;
        }

        private synchronized void refresh() {
            long now = System.currentTimeMillis();
            if (now - this.lastUpdated > this.ttl.toMillis()) {
                CacheableString result = this.keySupplier.get();
                this.publicKey = result.getValue();
                this.ttl = result.getCacheTTL();
                this.lastUpdated = now;
            }
        }
    }
}

